/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.rel.expressions.Expression;

@Evolving
public interface FunctionExpression
extends Expression {
    public static FuncExpressionImpl of(String functionName, Expression ... arguments) {
        return new FuncExpressionImpl(functionName, arguments);
    }

    public static FuncExpressionImpl of(String functionName) {
        return FunctionExpression.of(functionName, EMPTY_EXPRESSION);
    }

    public String functionName();

    public Expression[] arguments();

    @Override
    default public Expression[] children() {
        return this.arguments();
    }

    public static final class FuncExpressionImpl
    implements FunctionExpression {
        private final String functionName;
        private final Expression[] arguments;

        private FuncExpressionImpl(String functionName, Expression[] arguments) {
            this.functionName = functionName;
            this.arguments = arguments;
        }

        @Override
        public String functionName() {
            return this.functionName;
        }

        @Override
        public Expression[] arguments() {
            return this.arguments;
        }

        public String toString() {
            if (this.arguments.length == 0) {
                return this.functionName + "()";
            }
            return this.functionName + Arrays.stream(this.arguments).map(Object::toString).collect(Collectors.joining(", ", "(", ")"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FuncExpressionImpl that = (FuncExpressionImpl)o;
            return Objects.equals(this.functionName, that.functionName) && Arrays.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            int result = Objects.hash(this.functionName);
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }
    }
}

