/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ByteStack;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.ByteStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

final class ImmutableByteEmptyStack
implements ImmutableByteStack,
Serializable {
    static final ImmutableByteStack INSTANCE = new ImmutableByteEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableByteEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ByteIterator byteIterator() {
        return ImmutableEmptyByteIterator.INSTANCE;
    }

    public void forEach(ByteProcedure procedure) {
    }

    public void each(ByteProcedure procedure) {
    }

    public int count(BytePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return true;
    }

    public byte peek() {
        throw new EmptyStackException();
    }

    public ByteList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new ByteArrayList(0);
        }
        throw new EmptyStackException();
    }

    public byte peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableByteStack select(BytePredicate predicate) {
        return this;
    }

    public ImmutableByteStack reject(BytePredicate predicate) {
        return this;
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(ByteToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    public long sum() {
        return 0L;
    }

    public byte max() {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public byte min() {
        throw new NoSuchElementException();
    }

    public byte minIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray() {
        return new byte[0];
    }

    public MutableByteList toSortedList() {
        return new ByteArrayList();
    }

    public byte[] toArray() {
        return new byte[0];
    }

    public byte[] toArray(byte[] target) {
        return target;
    }

    public boolean contains(byte value) {
        return false;
    }

    public boolean containsAll(byte ... source) {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source) {
        return source.isEmpty();
    }

    public MutableByteList toList() {
        return new ByteArrayList();
    }

    public MutableByteSet toSet() {
        return new ByteHashSet();
    }

    public MutableByteBag toBag() {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableByteStack toImmutable() {
        return this;
    }

    public ImmutableByteStack push(byte element) {
        return ByteStacks.immutable.with(element);
    }

    public ImmutableByteStack pop() {
        throw new EmptyStackException();
    }

    public ImmutableByteStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public RichIterable<ByteIterable> chunk(int size) {
        return Lists.immutable.empty();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ByteStack)) {
            return false;
        }
        ByteStack stack = (ByteStack)otherStack;
        return stack.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(byte value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(ByteIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }
}

