/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.impl;

import groovy.lang.Closure;
import groovyx.gpars.MessagingRunnable;
import groovyx.gpars.dataflow.DataflowVariable;

public class ThenMessagingRunnable<T, V>
extends MessagingRunnable<T> {
    private final DataflowVariable<V> result;
    private final Closure<V> closure;
    private final Closure<V> errorHandler;

    public ThenMessagingRunnable(DataflowVariable<V> result, Closure<V> closure) {
        this(result, closure, null);
    }

    public ThenMessagingRunnable(DataflowVariable<V> result, Closure<V> closure, Closure<V> errorHandler) {
        if (closure.getMaximumNumberOfParameters() > 1) {
            throw new IllegalArgumentException("The supplied closure expects more than one argument.");
        }
        if (errorHandler != null && errorHandler.getMaximumNumberOfParameters() > 1) {
            throw new IllegalArgumentException("The supplied error handler expects more than one argument.");
        }
        this.result = result;
        this.closure = closure;
        this.errorHandler = errorHandler;
    }

    @Override
    protected void doRun(T argument) {
        if (argument instanceof Throwable) {
            if (this.errorHandler != null && this.shallHandle(this.errorHandler, (Throwable)argument)) {
                try {
                    this.result.leftShift(this.errorHandler.getMaximumNumberOfParameters() == 1 ? this.errorHandler.call(argument) : this.errorHandler.call());
                }
                catch (Throwable e) {
                    this.result.bindError(e);
                }
            } else {
                this.result.bindError((Throwable)argument);
            }
        } else {
            try {
                this.result.leftShift(this.closure.getMaximumNumberOfParameters() == 1 ? this.closure.call(argument) : this.closure.call());
            }
            catch (Throwable e) {
                this.result.bindError(e);
            }
        }
    }

    private boolean shallHandle(Closure<V> errorHandler, Throwable e) {
        Class[] types = errorHandler.getParameterTypes();
        if (types.length == 0) {
            return true;
        }
        return types[0].isAssignableFrom(e.getClass());
    }
}

