/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NamenodeFsck;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestFsck {
    private static final Log LOG = LogFactory.getLog((String)TestFsck.class.getName());
    static final String AUDITLOG_FILE = GenericTestUtils.getTempPath((String)"TestFsck-audit.log");
    static final Pattern FSCK_PATTERN = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=fsck\\ssrc=\\/\\sdst=null\\sperm=null\\sproto=.*");
    static final Pattern GET_FILE_INFO_PATTERN = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=getfileinfo\\ssrc=\\/\\sdst=null\\sperm=null\\sproto=.*");
    static final Pattern NUM_CORRUPT_BLOCKS_PATTERN = Pattern.compile(".*Corrupt blocks:\t\t([0123456789]*).*");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private MiniDFSCluster cluster = null;
    private Configuration conf = null;

    public static String runFsck(Configuration conf, int expectedErrCode, boolean checkErrorCode, String ... path) throws Exception {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        GenericTestUtils.setLogLevel((Log)FSPermissionChecker.LOG, (Level)Level.ALL);
        int errCode = ToolRunner.run((Tool)new DFSck(conf, out), (String[])path);
        LOG.info((Object)("OUTPUT = " + bStream.toString()));
        if (checkErrorCode) {
            Assert.assertEquals((long)expectedErrCode, (long)errCode);
        }
        GenericTestUtils.setLogLevel((Log)FSPermissionChecker.LOG, (Level)Level.INFO);
        return bStream.toString();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
    }

    @After
    public void tearDown() throws Exception {
        this.shutdownCluster();
    }

    private void shutdownCluster() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFsck() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(20).build();
        DistributedFileSystem fs = null;
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(4).build();
        fs = this.cluster.getFileSystem();
        String fileName = "/srcdat";
        util.createFiles((FileSystem)fs, "/srcdat");
        util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
        Path file = new Path("/srcdat");
        long aTime = fs.getFileStatus(file).getAccessTime();
        Thread.sleep(1L);
        this.setupAuditLogs();
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        this.verifyAuditLogs();
        Assert.assertEquals((long)aTime, (long)fs.getFileStatus(file).getAccessTime());
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        this.shutdownCluster();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).build();
        outStr = TestFsck.runFsck(this.conf, 1, true, "/");
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
        System.out.println(outStr);
        this.cluster.startDataNodes(this.conf, 4, true, null, null);
        this.cluster.waitActive();
        this.cluster.waitClusterUp();
        fs = this.cluster.getFileSystem();
        util.cleanup((FileSystem)fs, "/srcdat");
    }

    private void setupAuditLogs() throws IOException {
        File file = new File(AUDITLOG_FILE);
        if (file.exists()) {
            file.delete();
        }
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.removeAllAppenders();
        logger.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%m%n");
        RollingFileAppender appender = new RollingFileAppender((Layout)layout, AUDITLOG_FILE);
        logger.addAppender((Appender)appender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAuditLogs() throws IOException {
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.OFF);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(AUDITLOG_FILE));
            for (int i = 0; i < 2; ++i) {
                line = reader.readLine();
                Assert.assertNotNull((Object)line);
                Assert.assertTrue((String)"Expected getfileinfo event not found in audit log", (boolean)GET_FILE_INFO_PATTERN.matcher(line).matches());
            }
            line = reader.readLine();
            Assert.assertNotNull((Object)line);
            Assert.assertTrue((String)"Expected fsck event not found in audit log", (boolean)FSCK_PATTERN.matcher(line).matches());
            Assert.assertNull((String)"Unexpected event in audit log", (Object)reader.readLine());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (logger != null) {
                logger.removeAllAppenders();
            }
        }
    }

    @Test
    public void testFsckNonExistent() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(20).build();
        DistributedFileSystem fs = null;
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(4).build();
        fs = this.cluster.getFileSystem();
        util.createFiles((FileSystem)fs, "/srcdat");
        util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/non-existent");
        Assert.assertEquals((long)-1L, (long)outStr.indexOf("is HEALTHY"));
        System.out.println(outStr);
        util.cleanup((FileSystem)fs, "/srcdat");
    }

    @Test
    public void testFsckPermission() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(20).build();
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        MiniDFSCluster c2 = this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(4).build();
        String dir = "/dfsck";
        Path dirpath = new Path("/dfsck");
        DistributedFileSystem fs = c2.getFileSystem();
        util.createFiles((FileSystem)fs, "/dfsck");
        util.waitReplication((FileSystem)fs, "/dfsck", (short)3);
        fs.setPermission(dirpath, new FsPermission(448));
        UserGroupInformation fakeUGI = UserGroupInformation.createUserForTesting((String)"ProbablyNotARealUserName", (String[])new String[]{"ShangriLa"});
        fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                System.out.println(TestFsck.runFsck(TestFsck.this.conf, -1, true, "/dfsck"));
                return null;
            }
        });
        fs.setPermission(dirpath, new FsPermission(511));
        fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                String outStr = TestFsck.runFsck(TestFsck.this.conf, 0, true, "/dfsck");
                System.out.println(outStr);
                Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
                return null;
            }
        });
        util.cleanup((FileSystem)fs, "/dfsck");
    }

    @Test
    public void testFsckMove() throws Exception {
        int dfsBlockSize = 1024;
        int numDatanodes = 4;
        this.conf.setLong("dfs.blocksize", 1024L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DFSTestUtil util = new DFSTestUtil("TestFsck", 5, 3, 6143, 5120);
        DistributedFileSystem fs = null;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(4).build();
        String topDir = "/srcdat";
        fs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        util.createFiles((FileSystem)fs, topDir);
        util.waitReplication((FileSystem)fs, topDir, (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        String[] fileNames = util.getFileNames(topDir);
        CorruptedTestFile[] ctFiles = new CorruptedTestFile[]{new CorruptedTestFile(fileNames[0], Sets.newHashSet((Object[])new Integer[]{0}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[1], Sets.newHashSet((Object[])new Integer[]{2, 3}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[2], Sets.newHashSet((Object[])new Integer[]{4}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[3], Sets.newHashSet((Object[])new Integer[]{0, 1, 2, 3}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[4], Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4}), dfsClient, 4, 1024)};
        int totalMissingBlocks = 0;
        for (CorruptedTestFile ctFile : ctFiles) {
            totalMissingBlocks += ctFile.getTotalMissingBlocks();
        }
        for (CorruptedTestFile ctFile : ctFiles) {
            ctFile.removeBlocks(this.cluster);
        }
        while (true) {
            outStr = TestFsck.runFsck(this.conf, 1, false, "/");
            String numCorrupt = null;
            for (String line : outStr.split(LINE_SEPARATOR)) {
                Matcher m = NUM_CORRUPT_BLOCKS_PATTERN.matcher(line);
                if (!m.matches()) continue;
                numCorrupt = m.group(1);
                break;
            }
            if (numCorrupt == null) {
                throw new IOException("failed to find number of corrupt blocks in fsck output.");
            }
            if (numCorrupt.equals(Integer.toString(totalMissingBlocks))) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException arr$) {}
        }
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
        outStr = TestFsck.runFsck(this.conf, 1, false, "/", "-move");
        LOG.info((Object)("WATERMELON: outStr = " + outStr));
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
        for (CorruptedTestFile ctFile : ctFiles) {
            ctFile.checkSalvagedRemains();
        }
        outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-delete");
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        util.cleanup((FileSystem)fs, topDir);
    }

    @Test
    public void testFsckMoveAndDelete() throws Exception {
        int i2;
        int maxMoveTries = 5;
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsckMoveAndDelete").setNumFiles(5).build();
        DistributedFileSystem fs = null;
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(4).build();
        String topDir = "/srcdat";
        fs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        util.createFiles((FileSystem)fs, topDir);
        util.waitReplication((FileSystem)fs, topDir, (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        String[] fileNames = util.getFileNames(topDir);
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        String corruptFileName = fileNames[0];
        ExtendedBlock block = dfsClient.getNamenode().getBlockLocations(corruptFileName, 0L, Long.MAX_VALUE).get(0).getBlock();
        for (i2 = 0; i2 < 4; ++i2) {
            File blockFile = this.cluster.getBlockFile(i2, block);
            if (blockFile == null || !blockFile.exists()) continue;
            Assert.assertTrue((boolean)blockFile.delete());
        }
        outStr = TestFsck.runFsck(this.conf, 1, false, "/");
        while (!outStr.contains("is CORRUPT")) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException i2) {
                // empty catch block
            }
            outStr = TestFsck.runFsck(this.conf, 1, false, "/");
        }
        for (i2 = 0; i2 < 5; ++i2) {
            outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-move");
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
            String[] newFileNames = util.getFileNames(topDir);
            boolean found = false;
            for (String f : newFileNames) {
                if (!f.equals(corruptFileName)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-move", "-delete");
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        util.cleanup((FileSystem)fs, topDir);
    }

    @Test
    public void testFsckOpenFiles() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(4).build();
        DistributedFileSystem fs = null;
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(4).build();
        String topDir = "/srcdat";
        String randomString = "HADOOP  ";
        fs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        util.createFiles((FileSystem)fs, topDir);
        util.waitReplication((FileSystem)fs, topDir, (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Path openFile = new Path(topDir + "/openFile");
        FSDataOutputStream out = fs.create(openFile);
        for (int writeCount = 0; writeCount != 100; ++writeCount) {
            out.write(randomString.getBytes());
        }
        ((DFSOutputStream)out.getWrappedStream()).hflush();
        outStr = TestFsck.runFsck(this.conf, 0, true, topDir);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assert.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
        outStr = TestFsck.runFsck(this.conf, 0, true, topDir, "-openforwrite");
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("OPENFORWRITE"));
        Assert.assertTrue((boolean)outStr.contains("openFile"));
        out.close();
        outStr = TestFsck.runFsck(this.conf, 0, true, topDir);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assert.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
        util.cleanup((FileSystem)fs, topDir);
    }

    @Test
    public void testCorruptBlock() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        DistributedFileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        int factor = 1;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(1).build();
        this.cluster.waitActive();
        fs = this.cluster.getFileSystem();
        Path file1 = new Path("/testCorruptBlock");
        DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, (short)factor, 0L);
        DFSTestUtil.waitReplication((FileSystem)fs, file1, (short)factor);
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file1);
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        File blockFile = this.cluster.getBlockFile(0, block);
        if (blockFile != null && blockFile.exists()) {
            RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
            FileChannel channel = raFile.getChannel();
            String badString = "BADBAD";
            int rand = random.nextInt((int)channel.size() / 2);
            raFile.seek(rand);
            raFile.write(badString.getBytes());
            raFile.close();
        }
        try {
            IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)this.conf, (boolean)true);
        }
        catch (IOException ie) {
            Assert.assertTrue((boolean)(ie instanceof ChecksumException));
        }
        dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
        replicaCount = blocks.get(0).getLocations().length;
        while (replicaCount != factor) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
        }
        Assert.assertTrue((boolean)blocks.get(0).isCorrupt());
        outStr = TestFsck.runFsck(this.conf, 1, true, "/");
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
        Assert.assertTrue((boolean)outStr.contains("testCorruptBlock"));
    }

    @Test
    public void testUnderMinReplicatedBlock() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        short minReplication = 2;
        this.conf.setInt("dfs.namenode.replication.min", (int)minReplication);
        DistributedFileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        int factor = 1;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(2).build();
        this.cluster.waitActive();
        fs = this.cluster.getFileSystem();
        Path file1 = new Path("/testUnderMinReplicatedBlock");
        DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, minReplication, 0L);
        DFSTestUtil.waitReplication((FileSystem)fs, file1, minReplication);
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file1);
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        File blockFile = this.cluster.getBlockFile(0, block);
        if (blockFile != null && blockFile.exists()) {
            RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
            FileChannel channel = raFile.getChannel();
            String badString = "BADBAD";
            int rand = random.nextInt((int)channel.size() / 2);
            raFile.seek(rand);
            raFile.write(badString.getBytes());
            raFile.close();
        }
        dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
        replicaCount = blocks.get(0).getLocations().length;
        while (replicaCount != factor) {
            try {
                Thread.sleep(100L);
                try {
                    IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)this.conf, (boolean)true);
                }
                catch (IOException ie) {
                    Assert.assertTrue((boolean)(ie instanceof ChecksumException));
                }
                System.out.println("sleep in try: replicaCount=" + replicaCount + "  factor=" + factor);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
        }
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assert.assertTrue((boolean)outStr.contains("UNDER MIN REPL'D BLOCKS:\t1 (100.0 %)"));
        Assert.assertTrue((boolean)outStr.contains("dfs.namenode.replication.min:\t2"));
    }

    @Test(timeout=90000L)
    public void testFsckReplicaDetails() throws Exception {
        boolean replFactor = true;
        int numDn = 1;
        long blockSize = 512L;
        long fileSize = 1024L;
        String[] racks = new String[]{"/rack1"};
        String[] hosts = new String[]{"host1"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        this.cluster.waitClusterUp();
        final DistributedFileSystem dfs = this.cluster.getFileSystem();
        String testFile = new String("/testfile");
        Path path = new Path(testFile);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        String fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assert.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
        Assert.assertTrue((boolean)fsckOut.contains("(LIVE)"));
        Assert.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assert.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dnm = bm.getDatanodeManager();
        DatanodeDescriptor dnDesc0 = dnm.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        bm.getDatanodeManager().getDatanodeAdminManager().startDecommission(dnDesc0);
        final String dn0Name = dnDesc0.getXferAddr();
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assert.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONING)"));
        Assert.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assert.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack2"}, new String[]{"host2"}, null, false);
        final AtomicBoolean checkDecommissionInProgress = new AtomicBoolean(false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dn0Name.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (!checkDecommissionInProgress.get() && datanodeInfo != null && datanodeInfo.isDecommissionInProgress()) {
                        checkDecommissionInProgress.set(true);
                    }
                    if (datanodeInfo != null && datanodeInfo.isDecommissioned()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unexpected exception: " + e));
                    return false;
                }
                return false;
            }
        }, (int)500, (int)30000);
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assert.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assert.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assert.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        DatanodeDescriptor dnDesc1 = dnm.getDatanode(this.cluster.getDataNodes().get(1).getDatanodeId());
        final String dn1Name = dnDesc1.getXferAddr();
        bm.getDatanodeManager().getDatanodeAdminManager().startMaintenance(dnDesc1, Long.MAX_VALUE);
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assert.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assert.assertTrue((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assert.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-blocks", "-replicaDetails");
        Assert.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assert.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assert.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack3"}, new String[]{"host3"}, null, false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                DatanodeInfo dnInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dn1Name.equals(info.getXferAddr())) continue;
                        dnInfo = info;
                    }
                    if (dnInfo != null && dnInfo.isInMaintenance()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unexpected exception: " + e));
                    return false;
                }
                return false;
            }
        }, (int)500, (int)30000);
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assert.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assert.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assert.assertTrue((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-blocks", "-replicaDetails");
        Assert.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assert.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assert.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
    }

    @Test
    public void testFsckError() throws Exception {
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).build();
        String fileName = "/test.txt";
        Path filePath = new Path(fileName);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        INodeFile node = (INodeFile)this.cluster.getNamesystem().dir.getINode(fileName, FSDirectory.DirOp.READ);
        BlockInfo[] blocks = node.getBlocks();
        Assert.assertEquals((long)blocks.length, (long)1L);
        blocks[0].setNumBytes(-1L);
        String outStr = TestFsck.runFsck(this.conf, -1, true, fileName);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("FAILED"));
        fs.delete(filePath, true);
    }

    @Test
    public void testFsckListCorruptFilesBlocks() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).build();
        this.cluster.waitActive();
        fs = this.cluster.getFileSystem();
        DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
        util.createFiles((FileSystem)fs, "/corruptData", (short)1);
        util.waitReplication((FileSystem)fs, "/corruptData", (short)1);
        String outStr = TestFsck.runFsck(this.conf, 0, false, "/corruptData", "-list-corruptfileblocks");
        System.out.println("1. good fsck out: " + outStr);
        Assert.assertTrue((boolean)outStr.contains("has 0 CORRUPT files"));
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j <= 1; ++j) {
                File storageDir = this.cluster.getInstanceStorageDir(i, j);
                File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(dataDir);
                if (metadataFiles == null) continue;
                for (File metadataFile : metadataFiles) {
                    File blockFile = Block.metaToBlockFile((File)metadataFile);
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)blockFile.delete());
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)metadataFile.delete());
                }
            }
        }
        this.waitForCorruptionBlocks(3, "/corruptData");
        outStr = TestFsck.runFsck(this.conf, -1, true, "/corruptData", "-list-corruptfileblocks");
        System.out.println("2. bad fsck out: " + outStr);
        Assert.assertTrue((boolean)outStr.contains("has 3 CORRUPT files"));
        util.createFiles((FileSystem)fs, "/goodData");
        outStr = TestFsck.runFsck(this.conf, 0, true, "/goodData", "-list-corruptfileblocks");
        System.out.println("3. good fsck out: " + outStr);
        Assert.assertTrue((boolean)outStr.contains("has 0 CORRUPT files"));
        util.cleanup((FileSystem)fs, "/corruptData");
        util.cleanup((FileSystem)fs, "/goodData");
    }

    @Test
    public void testToCheckTheFsckCommandOnIllegalArguments() throws Exception {
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).build();
        String fileName = "/test.txt";
        Path filePath = new Path(fileName);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        String outStr = TestFsck.runFsck(this.conf, -1, true, fileName, "-thisIsNotAValidFlag");
        System.out.println(outStr);
        Assert.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
        outStr = TestFsck.runFsck(this.conf, -1, true, "/", fileName);
        System.out.println(outStr);
        Assert.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
        fs.delete(filePath, true);
    }

    @Test
    public void testFsckMissingReplicas() throws IOException {
        int replFactor = 2;
        boolean numReplicas = true;
        int numBlocks = 3;
        long blockSize = 512L;
        this.conf.setLong("dfs.blocksize", 512L);
        DistributedFileSystem dfs = null;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(1).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        long fileLen = 1536L;
        DFSTestUtil.createFile((FileSystem)dfs, path, fileLen, (short)2, 1L);
        NameNode namenode = this.cluster.getNameNode();
        NetworkTopology nettop = this.cluster.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology();
        HashMap pmap = new HashMap();
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)result, true);
        InetAddress remoteAddress = InetAddress.getLocalHost();
        NamenodeFsck fsck = new NamenodeFsck(this.conf, namenode, nettop, pmap, out, 1, remoteAddress);
        HdfsFileStatus file = namenode.getRpcServer().getFileInfo(pathString);
        Assert.assertNotNull((Object)file);
        NamenodeFsck.Result res = new NamenodeFsck.Result(this.conf);
        fsck.check(pathString, file, res);
        System.out.println(((Object)result).toString());
        Assert.assertEquals((long)res.missingReplicas, (long)3L);
        Assert.assertEquals((long)res.numExpectedReplicas, (long)6L);
    }

    @Test
    public void testFsckMisPlacedReplicas() throws IOException {
        int replFactor = 2;
        int numDn = 2;
        int numBlocks = 3;
        long blockSize = 512L;
        String[] racks = new String[]{"/rack1", "/rack1"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        DistributedFileSystem dfs = null;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        long fileLen = 1536L;
        DFSTestUtil.createFile((FileSystem)dfs, path, fileLen, (short)2, 1L);
        NameNode namenode = this.cluster.getNameNode();
        NetworkTopology nettop = this.cluster.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology();
        nettop.add((Node)DFSTestUtil.getDatanodeDescriptor("/rack2", "/host3"));
        numDn = (short)(numDn + 1);
        HashMap pmap = new HashMap();
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)result, true);
        InetAddress remoteAddress = InetAddress.getLocalHost();
        NamenodeFsck fsck = new NamenodeFsck(this.conf, namenode, nettop, pmap, out, numDn, remoteAddress);
        HdfsFileStatus file = namenode.getRpcServer().getFileInfo(pathString);
        Assert.assertNotNull((Object)file);
        NamenodeFsck.Result res = new NamenodeFsck.Result(this.conf);
        fsck.check(pathString, file, res);
        Assert.assertEquals((long)res.numMisReplicatedBlocks, (long)3L);
    }

    @Test
    public void testFsckFileNotFound() throws Exception {
        boolean numReplicas = true;
        NameNode namenode = (NameNode)Mockito.mock(NameNode.class);
        NetworkTopology nettop = (NetworkTopology)Mockito.mock(NetworkTopology.class);
        HashMap pmap = new HashMap();
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)result, true);
        InetAddress remoteAddress = InetAddress.getLocalHost();
        FSNamesystem fsName = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        FSDirectory fsd = (FSDirectory)Mockito.mock(FSDirectory.class);
        BlockManager blockManager = (BlockManager)Mockito.mock(BlockManager.class);
        DatanodeManager dnManager = (DatanodeManager)Mockito.mock(DatanodeManager.class);
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        Mockito.when((Object)namenode.getNamesystem()).thenReturn((Object)fsName);
        Mockito.when((Object)fsName.getBlockManager()).thenReturn((Object)blockManager);
        Mockito.when((Object)fsName.getFSDirectory()).thenReturn((Object)fsd);
        Mockito.when((Object)fsd.getFSNamesystem()).thenReturn((Object)fsName);
        Mockito.when((Object)fsd.resolvePath((FSPermissionChecker)Matchers.any(FSPermissionChecker.class), Matchers.anyString(), (FSDirectory.DirOp)Matchers.any(FSDirectory.DirOp.class))).thenReturn((Object)iip);
        Mockito.when((Object)blockManager.getDatanodeManager()).thenReturn((Object)dnManager);
        NamenodeFsck fsck = new NamenodeFsck(this.conf, namenode, nettop, pmap, out, 1, remoteAddress);
        String pathString = "/tmp/testFile";
        long length = 123L;
        boolean isDir = false;
        int blockReplication = 1;
        long blockSize = 131072L;
        long modTime = 123123123L;
        long accessTime = 123123120L;
        FsPermission perms = FsPermission.getDefault();
        String owner = "foo";
        String group = "bar";
        byte[] symlink = null;
        byte[] path = DFSUtil.string2Bytes((String)pathString);
        long fileId = 312321L;
        int numChildren = 1;
        byte storagePolicy = 0;
        HdfsFileStatus file = new HdfsFileStatus(length, isDir, blockReplication, blockSize, modTime, accessTime, perms, owner, group, symlink, path, fileId, numChildren, null, storagePolicy);
        NamenodeFsck.Result res = new NamenodeFsck.Result(this.conf);
        try {
            fsck.check(pathString, file, res);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        Assert.assertTrue((boolean)res.toString().contains("HEALTHY"));
    }

    @Test
    public void testFsckSymlink() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        DistributedFileSystem fs = null;
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(4).build();
        fs = this.cluster.getFileSystem();
        String fileName = "/srcdat";
        util.createFiles((FileSystem)fs, "/srcdat");
        FileContext fc = FileContext.getFileContext((Configuration)this.cluster.getConfiguration(0));
        Path file = new Path("/srcdat");
        Path symlink = new Path("/srcdat-symlink");
        fc.createSymlink(file, symlink, false);
        util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
        long aTime = fc.getFileStatus(symlink).getAccessTime();
        Thread.sleep(1L);
        this.setupAuditLogs();
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        this.verifyAuditLogs();
        Assert.assertEquals((long)aTime, (long)fc.getFileStatus(symlink).getAccessTime());
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assert.assertTrue((boolean)outStr.contains("Total symlinks:\t\t1"));
        util.cleanup((FileSystem)fs, "/srcdat");
    }

    @Test
    public void testFsckForSnapshotFiles() throws Exception {
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(1).build();
        String runFsck = TestFsck.runFsck(this.conf, 0, true, "/", "-includeSnapshots", "-files");
        Assert.assertTrue((boolean)runFsck.contains("HEALTHY"));
        String fileName = "/srcdat";
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        Path file1 = new Path("/srcdat");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)1, 1000L);
        hdfs.allowSnapshot(new Path("/"));
        hdfs.createSnapshot(new Path("/"), "mySnapShot");
        runFsck = TestFsck.runFsck(this.conf, 0, true, "/", "-includeSnapshots", "-files");
        Assert.assertTrue((boolean)runFsck.contains("/.snapshot/mySnapShot/srcdat"));
        runFsck = TestFsck.runFsck(this.conf, 0, true, "/", "-files");
        Assert.assertFalse((boolean)runFsck.contains("mySnapShot"));
    }

    @Test
    public void testBlockIdCK() throws Exception {
        int replFactor = 2;
        int numDn = 2;
        long blockSize = 512L;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        DistributedFileSystem dfs = null;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)2, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)2);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String runFsckResult = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", "not_a_block_id");
        Assert.assertTrue((boolean)runFsckResult.contains("Incorrect blockId format:"));
        runFsckResult = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", sb.toString());
        Assert.assertTrue((boolean)runFsckResult.contains(bIds[0]));
        Assert.assertTrue((boolean)runFsckResult.contains(bIds[1]));
        Assert.assertTrue((boolean)runFsckResult.contains("Block replica on datanode/rack: host1/rack1 is HEALTHY"));
        Assert.assertTrue((boolean)runFsckResult.contains("Block replica on datanode/rack: host2/rack2 is HEALTHY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockIdCKDecommission() throws Exception {
        String fsckOut;
        boolean replFactor = true;
        int numDn = 2;
        long blockSize = 512L;
        boolean checkDecommissionInProgress = false;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", bIds[0]);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        ExtendedBlock eb = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
        INodeFile bc = null;
        try {
            fsn.writeLock();
            BlockInfo bi = bm.getStoredBlock(eb.getLocalBlock());
            bc = fsn.getBlockCollection(bi);
        }
        finally {
            fsn.writeUnlock();
        }
        DatanodeDescriptor dn = bc.getBlocks()[0].getDatanode(0);
        bm.getDatanodeManager().getDatanodeAdminManager().startDecommission(dn);
        String dnName = dn.getXferAddr();
        DatanodeInfo datanodeInfo = null;
        boolean count = false;
        do {
            Thread.sleep(2000L);
            for (DatanodeInfo info : dfs.getDataNodeStats()) {
                if (!dnName.equals(info.getXferAddr())) continue;
                datanodeInfo = info;
            }
            if (checkDecommissionInProgress || datanodeInfo == null || !datanodeInfo.isDecommissionInProgress()) continue;
            fsckOut = TestFsck.runFsck(this.conf, 3, true, "/", "-blockId", bIds[0]);
            Assert.assertTrue((boolean)fsckOut.contains("is DECOMMISSIONING"));
            checkDecommissionInProgress = true;
        } while (datanodeInfo != null && !datanodeInfo.isDecommissioned());
        fsckOut = TestFsck.runFsck(this.conf, 2, true, "/", "-blockId", bIds[0]);
        Assert.assertTrue((boolean)fsckOut.contains("is DECOMMISSIONED"));
    }

    @Test(timeout=90000L)
    public void testBlockIdCKMaintenance() throws Exception {
        int replFactor = 2;
        int numDn = 2;
        long blockSize = 512L;
        String[] hosts = new String[]{"host1", "host2"};
        String[] racks = new String[]{"/rack1", "/rack2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        this.conf.setInt("dfs.namenode.replication.min", 2);
        this.conf.setInt("dfs.namenode.maintenance.replication.min", 2);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        final DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)2, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)2);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        final String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-maintenance", "-blockId", bIds[0]);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dnm = bm.getDatanodeManager();
        DatanodeDescriptor dn = dnm.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        bm.getDatanodeManager().getDatanodeAdminManager().startMaintenance(dn, Long.MAX_VALUE);
        final String dnName = dn.getXferAddr();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isEnteringMaintenance()) {
                        String fsckOut = TestFsck.runFsck(TestFsck.this.conf, 5, false, "/", "-maintenance", "-blockId", bIds[0]);
                        Assert.assertTrue((boolean)fsckOut.contains("is ENTERING MAINTENANCE"));
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unexpected exception: " + e));
                    return false;
                }
                return false;
            }
        }, (int)500, (int)30000);
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack3"}, new String[]{"host3"}, null, false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    DatanodeInfo datanodeInfo = null;
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isInMaintenance()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unexpected exception: " + e));
                    return false;
                }
                return false;
            }
        }, (int)500, (int)30000);
        String fsckOut = TestFsck.runFsck(this.conf, 4, false, "/", "-maintenance", "-blockId", bIds[0]);
        Assert.assertTrue((boolean)fsckOut.contains("is IN MAINTENANCE"));
        fsckOut = TestFsck.runFsck(this.conf, 4, false, "/", "-blockId", bIds[0]);
        Assert.assertFalse((boolean)fsckOut.contains("is IN MAINTENANCE"));
    }

    @Test
    public void testBlockIdCKCorruption() throws Exception {
        int numDn = 1;
        long blockSize = 512L;
        Random random = new Random();
        short repFactor = 1;
        String[] racks = new String[]{"/rack1"};
        String[] hosts = new String[]{"host1"};
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, repFactor, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, repFactor);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", bIds[0]);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
        File blockFile = this.cluster.getBlockFile(0, block);
        if (blockFile != null && blockFile.exists()) {
            RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
            FileChannel channel = raFile.getChannel();
            String badString = "BADBAD";
            int rand = random.nextInt((int)channel.size() / 2);
            raFile.seek(rand);
            raFile.write(badString.getBytes());
            raFile.close();
        }
        DFSTestUtil.waitCorruptReplicas((FileSystem)dfs, this.cluster.getNamesystem(), path, block, 1);
        outStr = TestFsck.runFsck(this.conf, 1, false, "/", "-blockId", block.getBlockName());
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
    }

    private void writeFile(DistributedFileSystem dfs, Path dir, String fileName) throws IOException {
        Path filePath = new Path(dir.toString() + "/" + fileName);
        FSDataOutputStream out = dfs.create(filePath);
        out.writeChars("teststring");
        out.close();
    }

    private void writeFile(DistributedFileSystem dfs, String dirName, String fileName, String storagePolicy) throws IOException {
        Path dirPath = new Path(dirName);
        dfs.mkdirs(dirPath);
        dfs.setStoragePolicy(dirPath, storagePolicy);
        this.writeFile(dfs, dirPath, fileName);
    }

    @Test
    public void testStoragePoliciesCK() throws Exception {
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(3).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        this.cluster.waitActive();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        this.writeFile(dfs, "/testhot", "file", "HOT");
        this.writeFile(dfs, "/testwarm", "file", "WARM");
        this.writeFile(dfs, "/testcold", "file", "COLD");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-storagepolicies");
        Assert.assertTrue((boolean)outStr.contains("DISK:3(HOT)"));
        Assert.assertTrue((boolean)outStr.contains("DISK:1,ARCHIVE:2(WARM)"));
        Assert.assertTrue((boolean)outStr.contains("ARCHIVE:3(COLD)"));
        Assert.assertTrue((boolean)outStr.contains("All blocks satisfy specified storage policy."));
        dfs.setStoragePolicy(new Path("/testhot"), "COLD");
        dfs.setStoragePolicy(new Path("/testwarm"), "COLD");
        outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-storagepolicies");
        Assert.assertTrue((boolean)outStr.contains("DISK:3(HOT)"));
        Assert.assertTrue((boolean)outStr.contains("DISK:1,ARCHIVE:2(WARM)"));
        Assert.assertTrue((boolean)outStr.contains("ARCHIVE:3(COLD)"));
        Assert.assertFalse((boolean)outStr.contains("All blocks satisfy specified storage policy."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckWithDecommissionedReplicas() throws Exception {
        String fsckOut;
        boolean replFactor = true;
        int numDn = 2;
        long blockSize = 512L;
        long fileSize = 1024L;
        boolean checkDecommissionInProgress = false;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String testFile = new String("/testfile");
        Path path = new Path(testFile);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        String outStr = TestFsck.runFsck(this.conf, 0, true, testFile);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        ExtendedBlock eb = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
        INodeFile bc = null;
        try {
            fsn.writeLock();
            BlockInfo bi = bm.getStoredBlock(eb.getLocalBlock());
            bc = fsn.getBlockCollection(bi);
        }
        finally {
            fsn.writeUnlock();
        }
        DatanodeDescriptor dn = bc.getBlocks()[0].getDatanode(0);
        bm.getDatanodeManager().getDatanodeAdminManager().startDecommission(dn);
        String dnName = dn.getXferAddr();
        DatanodeInfo datanodeInfo = null;
        boolean count = false;
        do {
            Thread.sleep(2000L);
            for (DatanodeInfo info : dfs.getDataNodeStats()) {
                if (!dnName.equals(info.getXferAddr())) continue;
                datanodeInfo = info;
            }
            if (checkDecommissionInProgress || datanodeInfo == null || !datanodeInfo.isDecommissionInProgress()) continue;
            fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile);
            checkDecommissionInProgress = true;
        } while (datanodeInfo != null && !datanodeInfo.isDecommissioned());
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile);
    }

    @Test(timeout=90000L)
    public void testFsckWithMaintenanceReplicas() throws Exception {
        int replFactor = 2;
        int numDn = 2;
        long blockSize = 512L;
        String[] hosts = new String[]{"host1", "host2"};
        String[] racks = new String[]{"/rack1", "/rack2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        this.conf.setInt("dfs.namenode.replication.min", 2);
        this.conf.setInt("dfs.namenode.maintenance.replication.min", 2);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        final DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        final String testFile = new String("/testfile");
        Path path = new Path(testFile);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)2, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)2);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, testFile);
        System.out.println(outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dnm = bm.getDatanodeManager();
        DatanodeDescriptor dn = dnm.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        bm.getDatanodeManager().getDatanodeAdminManager().startMaintenance(dn, Long.MAX_VALUE);
        final String dnName = dn.getXferAddr();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isEnteringMaintenance()) {
                        String fsckOut = TestFsck.runFsck(TestFsck.this.conf, 0, true, testFile, "-maintenance");
                        Assert.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unexpected exception: " + e));
                    return false;
                }
                return false;
            }
        }, (int)500, (int)30000);
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack3"}, new String[]{"host3"}, null, false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isInMaintenance()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unexpected exception: " + e));
                    return false;
                }
                return false;
            }
        }, (int)500, (int)30000);
        String fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-maintenance");
        Assert.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
        fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile);
        Assert.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
    }

    @Test
    public void testFsckListCorruptSnapshotFiles() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem hdfs = null;
        boolean replFactor = true;
        int numFiles = 3;
        int numSnapshots = 0;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).build();
        this.cluster.waitActive();
        hdfs = this.cluster.getFileSystem();
        DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(numFiles).setMaxLevels(1).setMaxSize(1024).build();
        util.createFiles((FileSystem)hdfs, "/corruptData", (short)1);
        Path fp = new Path("/corruptData/file");
        DFSTestUtil.createFile((FileSystem)hdfs, fp, 1024L, (short)1, 1000L);
        util.waitReplication((FileSystem)hdfs, "/corruptData", (short)1);
        hdfs.allowSnapshot(new Path("/corruptData"));
        hdfs.createSnapshot(new Path("/corruptData"), "mySnapShot");
        numSnapshots = ++numFiles;
        String outStr = TestFsck.runFsck(this.conf, 0, false, "/corruptData", "-list-corruptfileblocks");
        System.out.println("1. good fsck out: " + outStr);
        Assert.assertTrue((boolean)outStr.contains("has 0 CORRUPT files"));
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        for (int i = 0; i < numFiles; ++i) {
            for (int j = 0; j <= 1; ++j) {
                File storageDir = this.cluster.getInstanceStorageDir(i, j);
                File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(dataDir);
                if (metadataFiles == null) continue;
                for (File metadataFile : metadataFiles) {
                    File blockFile = Block.metaToBlockFile((File)metadataFile);
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)blockFile.delete());
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)metadataFile.delete());
                }
            }
        }
        hdfs.delete(fp, false);
        this.waitForCorruptionBlocks(numSnapshots, "/corruptData");
        outStr = TestFsck.runFsck(this.conf, -1, true, "/corruptData", "-list-corruptfileblocks", "-includeSnapshots");
        System.out.println("2. bad fsck include snapshot out: " + outStr);
        Assert.assertTrue((boolean)outStr.contains("has " + (--numFiles + numSnapshots) + " CORRUPT files"));
        Assert.assertTrue((boolean)outStr.contains("/.snapshot/"));
        outStr = TestFsck.runFsck(this.conf, -1, true, "/corruptData", "-list-corruptfileblocks");
        System.out.println("3. bad fsck exclude snapshot out: " + outStr);
        Assert.assertTrue((boolean)outStr.contains("has " + numFiles + " CORRUPT files"));
        Assert.assertFalse((boolean)outStr.contains("/.snapshot/"));
    }

    private void waitForCorruptionBlocks(final int corruptBlocks, final String path) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    NamenodeProtocols namenode = TestFsck.this.cluster.getNameNodeRpc();
                    CorruptFileBlocks corruptFileBlocks = namenode.listCorruptFileBlocks(path, null);
                    int numCorrupt = corruptFileBlocks.getFiles().length;
                    if (numCorrupt == corruptBlocks) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while getting Corrupt file blocks", (Throwable)e);
                }
                return false;
            }
        }, (int)100, (int)10000);
    }

    @Test(timeout=300000L)
    public void testFsckMoveAfterCorruption() throws Exception {
        int dfsBlockSize = 524288;
        boolean numDatanodes = true;
        boolean replication = true;
        this.conf.setLong("dfs.blocksize", 524288L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        this.conf.setInt("dfs.replication", 1);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).build();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        String srcDir = "/srcdat";
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setMinSize(0x100000).setMaxSize(0x180000).setNumFiles(1).build();
        util.createFiles((FileSystem)dfs, "/srcdat", (short)1);
        Object[] fileNames = util.getFileNames("/srcdat");
        LOG.info((Object)("Created files: " + Arrays.toString(fileNames)));
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-files", "-blocks");
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        Object blockFileToCorrupt = fileNames[0];
        final CorruptedTestFile ctf = new CorruptedTestFile((String)blockFileToCorrupt, Sets.newHashSet((Object[])new Integer[]{0}), dfsClient, 1, 524288);
        ctf.corruptBlocks(this.cluster);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    String str = TestFsck.runFsck(TestFsck.this.conf, 1, false, "/");
                    String numCorrupt = null;
                    for (String line : str.split(LINE_SEPARATOR)) {
                        Matcher m = NUM_CORRUPT_BLOCKS_PATTERN.matcher(line);
                        if (!m.matches()) continue;
                        numCorrupt = m.group(1);
                        break;
                    }
                    if (numCorrupt == null) {
                        Assert.fail((String)"Cannot find corrupt blocks count in fsck output.");
                    }
                    if (Integer.parseInt(numCorrupt) == ctf.getTotalMissingBlocks()) {
                        Assert.assertTrue((boolean)str.contains("is CORRUPT"));
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception caught", (Throwable)e);
                    Assert.fail((String)"Caught unexpected exception.");
                }
                return false;
            }
        }, (int)1000, (int)60000);
        TestFsck.runFsck(this.conf, 1, true, "/", "-files", "-blocks", "-racks");
        LOG.info((Object)"Moving blocks to lost+found");
        TestFsck.runFsck(this.conf, 1, false, "/", "-move");
        ArrayList<Object> retVal = new ArrayList<Object>();
        RemoteIterator iter = dfs.listFiles(new Path("/lost+found"), true);
        while (iter.hasNext()) {
            retVal.add(iter.next());
        }
        LOG.info((Object)("Items in lost+found: " + retVal));
        long totalLength = 0L;
        for (LocatedFileStatus locatedFileStatus : retVal) {
            totalLength += locatedFileStatus.getLen();
        }
        Assert.assertTrue((String)"Nothing is moved to lost+found!", (totalLength > 0L ? 1 : 0) != 0);
        util.cleanup((FileSystem)dfs, "/srcdat");
    }

    @Test(timeout=60000L)
    public void testFsckUpgradeDomain() throws Exception {
        this.testUpgradeDomain(false, false);
        this.testUpgradeDomain(false, true);
        this.testUpgradeDomain(true, false);
        this.testUpgradeDomain(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUpgradeDomain(boolean defineUpgradeDomain, boolean displayUpgradeDomain) throws Exception {
        boolean replFactor = true;
        boolean numDN = true;
        long blockSize = 512L;
        long fileSize = 1024L;
        String upgradeDomain = "ud1";
        String[] racks = new String[]{"/rack1"};
        String[] hosts = new String[]{"127.0.0.1"};
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        this.conf.set("hdfs.minidfs.basedir", GenericTestUtils.getRandomizedTempPath());
        if (defineUpgradeDomain) {
            this.conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
            hostsFileWriter.initialize(this.conf, "temp/fsckupgradedomain");
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).hosts(hosts).racks(racks).build();
        this.cluster.waitClusterUp();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        if (defineUpgradeDomain) {
            DatanodeAdminProperties dnProp = new DatanodeAdminProperties();
            DatanodeID datanodeID = this.cluster.getDataNodes().get(0).getDatanodeId();
            dnProp.setHostName(datanodeID.getHostName());
            dnProp.setPort(datanodeID.getXferPort());
            dnProp.setUpgradeDomain("ud1");
            hostsFileWriter.initIncludeHosts(new DatanodeAdminProperties[]{dnProp});
            this.cluster.getFileSystem().refreshNodes();
        }
        String testFile = new String("/testfile");
        Path path = new Path(testFile);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        try {
            String fsckOut = TestFsck.runFsck(this.conf, 0, true, testFile, "-files", "-blocks", displayUpgradeDomain ? "-upgradedomains" : "-locations");
            Assert.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
            String udValue = defineUpgradeDomain ? "ud1" : "undefined";
            Assert.assertEquals((Object)displayUpgradeDomain, (Object)fsckOut.contains("(ud=" + udValue + ")"));
        }
        finally {
            if (defineUpgradeDomain) {
                hostsFileWriter.cleanup();
            }
        }
    }

    @Test(timeout=300000L)
    public void testFsckCorruptWhenOneReplicaIsCorrupt() throws Exception {
        try (final MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf, new File(GenericTestUtils.getRandomizedTempPath())).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(2).build();){
            cluster.waitActive();
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            cluster.transitionToActive(0);
            String filePath = "/appendTest";
            Path fileName = new Path(filePath);
            DFSTestUtil.createFile((FileSystem)fs, fileName, 512L, (short)2, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            Assert.assertTrue((String)"File not created", (boolean)fs.exists(fileName));
            cluster.getDataNodes().get(1).shutdown();
            DFSTestUtil.appendFile((FileSystem)fs, fileName, "appendCorruptBlock");
            cluster.restartDataNode(1, true);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return cluster.getNameNode(0).getNamesystem().getCorruptReplicaBlocks() > 0L;
                }
            }, (int)100, (int)5000);
            DFSTestUtil.appendFile((FileSystem)fs, fileName, "appendCorruptBlock");
            TestFsck.runFsck(cluster.getConfiguration(0), 0, true, "/");
        }
    }

    private static class CorruptedTestFile {
        private final String name;
        private final Set<Integer> blocksToCorrupt;
        private final DFSClient dfsClient;
        private final int numDataNodes;
        private final int blockSize;
        private final byte[] initialContents;

        CorruptedTestFile(String name, Set<Integer> blocksToCorrupt, DFSClient dfsClient, int numDataNodes, int blockSize) throws IOException {
            this.name = name;
            this.blocksToCorrupt = blocksToCorrupt;
            this.dfsClient = dfsClient;
            this.numDataNodes = numDataNodes;
            this.blockSize = blockSize;
            this.initialContents = this.cacheInitialContents();
        }

        public int getTotalMissingBlocks() {
            return this.blocksToCorrupt.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] cacheInitialContents() throws IOException {
            HdfsFileStatus status = this.dfsClient.getFileInfo(this.name);
            byte[] content = new byte[(int)status.getLen()];
            try (DFSInputStream in = null;){
                in = this.dfsClient.open(this.name);
                IOUtils.readFully((InputStream)in, (byte[])content, (int)0, (int)content.length);
            }
            return content;
        }

        public void removeBlocks(MiniDFSCluster cluster) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            for (int corruptIdx : this.blocksToCorrupt) {
                ExtendedBlock block = this.dfsClient.getNamenode().getBlockLocations(this.name, (long)(this.blockSize * corruptIdx), Long.MAX_VALUE).get(0).getBlock();
                for (int i = 0; i < this.numDataNodes; ++i) {
                    File blockFile = cluster.getBlockFile(i, block);
                    if (blockFile == null || !blockFile.exists()) continue;
                    Assert.assertTrue((boolean)blockFile.delete());
                }
            }
        }

        public void corruptBlocks(MiniDFSCluster cluster) throws IOException {
            for (int corruptIdx : this.blocksToCorrupt) {
                ExtendedBlock block = this.dfsClient.getNamenode().getBlockLocations(this.name, (long)(this.blockSize * corruptIdx), Long.MAX_VALUE).get(0).getBlock();
                for (int i = 0; i < this.numDataNodes; ++i) {
                    File blockFile = cluster.getBlockFile(i, block);
                    if (blockFile == null || !blockFile.exists()) continue;
                    FileOutputStream blockFileStream = new FileOutputStream(blockFile, false);
                    blockFileStream.write("corrupt".getBytes());
                    blockFileStream.close();
                    LOG.info((Object)("Corrupted block file " + blockFile));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkSalvagedRemains() throws IOException {
            int chainIdx = 0;
            HdfsFileStatus status = this.dfsClient.getFileInfo(this.name);
            long length = status.getLen();
            int numBlocks = (int)((length + (long)this.blockSize - 1L) / (long)this.blockSize);
            DFSInputStream in = null;
            byte[] blockBuffer = new byte[this.blockSize];
            try {
                for (int blockIdx = 0; blockIdx < numBlocks; ++blockIdx) {
                    if (this.blocksToCorrupt.contains(blockIdx)) {
                        if (in == null) continue;
                        in.close();
                        in = null;
                        continue;
                    }
                    if (in == null) {
                        in = this.dfsClient.open("/lost+found" + this.name + "/" + chainIdx);
                        ++chainIdx;
                    }
                    int len = blockBuffer.length;
                    if (blockIdx == numBlocks - 1 && (len = (int)(in.getFileLength() % (long)this.blockSize)) == 0) {
                        len = blockBuffer.length;
                    }
                    IOUtils.readFully(in, (byte[])blockBuffer, (int)0, (int)len);
                    int startIdx = blockIdx * this.blockSize;
                    for (int i = 0; i < len; ++i) {
                        if (this.initialContents[startIdx + i] == blockBuffer[i]) continue;
                        throw new IOException("salvaged file " + this.name + " differed " + "from what we expected on block " + blockIdx);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
        }
    }
}

