/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidRegistry<T extends SchemaObject>
implements Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(OidRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Map<String, T> byOid = new HashMap<String, T>();

    public boolean contains(String oid) {
        return this.byOid.containsKey(oid);
    }

    public String getPrimaryName(String oid) throws LdapException {
        SchemaObject schemaObject = (SchemaObject)this.byOid.get(oid);
        if (schemaObject != null) {
            return schemaObject.getName();
        }
        String msg = I18n.err((I18n)I18n.ERR_04286, (Object[])new Object[]{oid});
        LOG.error(msg);
        throw new LdapException(msg);
    }

    public T getSchemaObject(String oid) throws LdapException {
        SchemaObject schemaObject = (SchemaObject)this.byOid.get(oid);
        if (schemaObject != null) {
            return (T)schemaObject;
        }
        String msg = I18n.err((I18n)I18n.ERR_04287, (Object[])new Object[]{oid});
        LOG.error(msg);
        throw new LdapException(msg);
    }

    public List<String> getNameSet(String oid) throws LdapException {
        SchemaObject schemaObject = (SchemaObject)this.byOid.get(oid);
        if (null == schemaObject) {
            String msg = I18n.err((I18n)I18n.ERR_04288, (Object[])new Object[]{oid});
            LOG.error(msg);
            throw new LdapException(msg);
        }
        List<String> names = schemaObject.getNames();
        if (IS_DEBUG) {
            LOG.debug("looked up names '{}' for OID '{}'", (Object)ArrayUtils.toString(names), (Object)oid);
        }
        return names;
    }

    public Iterator<String> iteratorOids() {
        return Collections.unmodifiableSet(this.byOid.keySet()).iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this.byOid.values().iterator();
    }

    public void register(T schemaObject) throws LdapException {
        if (schemaObject == null) {
            String message = I18n.err((I18n)I18n.ERR_04289, (Object[])new Object[0]);
            LOG.debug(message);
            throw new LdapException(message);
        }
        String oid = schemaObject.getOid();
        if (!Oid.isOid((String)oid)) {
            String message = I18n.err((I18n)I18n.ERR_04290, (Object[])new Object[0]);
            LOG.debug(message);
            throw new LdapException(message);
        }
        if (this.byOid.containsKey(oid)) {
            String message = I18n.err((I18n)I18n.ERR_04291, (Object[])new Object[]{oid});
            LOG.info(message);
            return;
        }
        this.byOid.put(oid, schemaObject);
        if (IS_DEBUG) {
            LOG.debug("registed SchemaObject '" + schemaObject + "' with OID: " + oid);
        }
    }

    void put(T schemaObject) {
        this.byOid.put(schemaObject.getOid(), schemaObject);
    }

    public void unregister(String oid) throws LdapException {
        SchemaObject removed = (SchemaObject)this.byOid.remove(oid);
        if (IS_DEBUG) {
            LOG.debug("Unregisted SchemaObject '{}' with OID: {}", (Object)removed, (Object)oid);
        }
    }

    public OidRegistry<T> copy() {
        OidRegistry<T> copy = new OidRegistry<T>();
        copy.byOid = new HashMap<String, T>();
        return copy;
    }

    public int size() {
        return this.byOid.size();
    }

    public void clear() {
        this.byOid.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.byOid != null) {
            boolean isFirst = true;
            for (String oid : this.byOid.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<");
                SchemaObject schemaObject = (SchemaObject)this.byOid.get(oid);
                if (schemaObject != null) {
                    sb.append((Object)schemaObject.getObjectType());
                    sb.append(", ");
                    sb.append(schemaObject.getOid());
                    sb.append(", ");
                    sb.append(schemaObject.getName());
                }
                sb.append(">");
            }
        }
        return sb.toString();
    }
}

