/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common;

import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;

public class SchedulerContainer<A extends SchedulerApplicationAttempt, N extends SchedulerNode> {
    private RMContainer rmContainer;
    private String nodePartition;
    private A schedulerApplicationAttempt;
    private N schedulerNode;
    private boolean allocated;

    public SchedulerContainer(A app, N node, RMContainer rmContainer, String nodePartition, boolean allocated) {
        this.schedulerApplicationAttempt = app;
        this.schedulerNode = node;
        this.rmContainer = rmContainer;
        this.nodePartition = nodePartition;
        this.allocated = allocated;
    }

    public String getNodePartition() {
        return this.nodePartition;
    }

    public RMContainer getRmContainer() {
        return this.rmContainer;
    }

    public A getSchedulerApplicationAttempt() {
        return this.schedulerApplicationAttempt;
    }

    public N getSchedulerNode() {
        return this.schedulerNode;
    }

    public boolean isAllocated() {
        return this.allocated;
    }

    public SchedulerRequestKey getSchedulerRequestKey() {
        if (this.rmContainer.getState() == RMContainerState.RESERVED) {
            return this.rmContainer.getReservedSchedulerKey();
        }
        return this.rmContainer.getAllocatedSchedulerKey();
    }

    public String toString() {
        return "(Application=" + ((SchedulerApplicationAttempt)this.schedulerApplicationAttempt).getApplicationAttemptId() + "; Node=" + ((SchedulerNode)this.schedulerNode).getNodeID() + "; Resource=" + this.rmContainer.getAllocatedOrReservedResource() + ")";
    }
}

