set hive.mapred.mode=nonstrict;
set hive.optimize.skewjoin.compiletime = true;
set hive.auto.convert.join=true;

CREATE TABLE T1_n155(key STRING, val STRING)
SKEWED BY (key, val) ON ((2, 12), (8, 18)) STORED AS TEXTFILE;

LOAD DATA LOCAL INPATH '../../data/files/T1.txt' INTO TABLE T1_n155;

CREATE TABLE T2_n91(key STRING, val STRING)
SKEWED BY (key, val) ON ((3, 13), (8, 18)) STORED AS TEXTFILE;

LOAD DATA LOCAL INPATH '../../data/files/T2.txt' INTO TABLE T2_n91;

-- copy from skewjoinopt6
-- test compile time skew join and auto map join
-- Both the join tables are skewed by 2 keys, and one of the skewed values
-- is common to both the tables. The join key is a subset of the skewed key set:
-- it only contains the first skewed key for both the tables
-- adding a order by at the end to make the results deterministic

EXPLAIN
SELECT a.*, b.* FROM T1_n155 a JOIN T2_n91 b ON a.key = b.key;

SELECT a.*, b.* FROM T1_n155 a JOIN T2_n91 b ON a.key = b.key
ORDER BY a.key, b.key, a.val, b.val;
