/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;

abstract class ShowCatalogsFormatter {
    ShowCatalogsFormatter() {
    }

    public static ShowCatalogsFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowCatalogsFormatter();
        }
        return new TextShowCatalogsFormatter();
    }

    abstract void showCatalogs(DataOutputStream var1, List<String> var2) throws HiveException;

    static class JsonShowCatalogsFormatter
    extends ShowCatalogsFormatter {
        JsonShowCatalogsFormatter() {
        }

        @Override
        void showCatalogs(DataOutputStream out, List<String> catalogs) throws HiveException {
            ShowUtils.asJson(out, MapBuilder.create().put("catalogs", catalogs).build());
        }
    }

    static class TextShowCatalogsFormatter
    extends ShowCatalogsFormatter {
        TextShowCatalogsFormatter() {
        }

        @Override
        void showCatalogs(DataOutputStream out, List<String> catalogs) throws HiveException {
            try {
                for (String catalog : catalogs) {
                    out.write(catalog.getBytes(StandardCharsets.UTF_8));
                    out.write(10);
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }
}

