/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.snapshotref.branch.rename;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.snapshotref.AlterTableSnapshotRefDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={892})
public class AlterTableRenameSnapshotRefAnalyzer
extends AbstractAlterTableAnalyzer {
    protected AlterTableType alterTableType = AlterTableType.RENAME_BRANCH;

    public AlterTableRenameSnapshotRefAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        DDLUtils.validateTableIsIceberg(table);
        this.inputs.add(new ReadEntity(table));
        this.validateAlterTableType(table, this.alterTableType, false);
        String sourceBranch = command.getChild(0).getText();
        String targetBranch = command.getChild(1).getText();
        AlterTableSnapshotRefSpec.RenameSnapshotrefSpec renameSnapshotrefSpec = new AlterTableSnapshotRefSpec.RenameSnapshotrefSpec(sourceBranch, targetBranch);
        AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.RenameSnapshotrefSpec> alterTableSnapshotRefSpec = new AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.RenameSnapshotrefSpec>(this.alterTableType, renameSnapshotrefSpec);
        AlterTableSnapshotRefDesc alterTableDesc = new AlterTableSnapshotRefDesc(this.alterTableType, tableName, alterTableSnapshotRefSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTableDesc)));
    }
}

