/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class TableInformation {
    private final int cacheGrpId;
    private final String cacheGrpName;
    private final int cacheId;
    private final String cacheName;
    private final String affinityKeyCol;
    private final String keyAlias;
    private final String valAlias;
    private final String keyTypeName;
    private final String valTypeName;
    private final String schemaName;
    private final String tblName;
    private final String tblType;

    public TableInformation(String schemaName, String tblName, String tblType, int cacheGrpId, String cacheGrpName, int cacheId, String cacheName, String affinityKeyCol, String keyAlias, String valAlias, String keyTypeName, String valTypeName) {
        assert (schemaName != null);
        assert (tblName != null);
        assert (tblType != null);
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.tblType = tblType;
        this.cacheGrpId = cacheGrpId;
        this.cacheGrpName = cacheGrpName;
        this.cacheId = cacheId;
        this.cacheName = cacheName;
        this.affinityKeyCol = affinityKeyCol;
        this.keyAlias = keyAlias;
        this.valAlias = valAlias;
        this.keyTypeName = keyTypeName;
        this.valTypeName = valTypeName;
    }

    public TableInformation(String schemaName, String tblName, String tblType) {
        assert (schemaName != null);
        assert (tblName != null);
        assert (tblType != null);
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.tblType = tblType;
        this.cacheGrpId = -1;
        this.cacheGrpName = null;
        this.cacheId = -1;
        this.cacheName = null;
        this.affinityKeyCol = null;
        this.keyAlias = null;
        this.valAlias = null;
        this.keyTypeName = null;
        this.valTypeName = null;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String tableType() {
        return this.tblType;
    }

    public int cacheGrpId() {
        return this.cacheGrpId;
    }

    public String cacheGrpName() {
        return this.cacheGrpName;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public String cacheName() {
        return this.cacheName;
    }

    @Nullable
    public String affinityKeyColumn() {
        return this.affinityKeyCol;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public String valueAlias() {
        return this.valAlias;
    }

    public String keyTypeName() {
        return this.keyTypeName;
    }

    public String valueTypeName() {
        return this.valTypeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInformation tblInfo = (TableInformation)o;
        return this.schemaName.equals(tblInfo.schemaName) && this.tblName.equals(tblInfo.tblName);
    }

    public int hashCode() {
        int res = this.schemaName.hashCode();
        res = 31 * res + this.tblName.hashCode();
        return res;
    }

    public String toString() {
        return S.toString(TableInformation.class, this);
    }
}

