/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.bifromq.basekv.raft.IPeerLogReplicator;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.PeerLogReplicator;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.event.SyncStateChangedEvent;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.slf4j.Logger;

class PeerLogTracker {
    private final String id;
    private final Map<String, IPeerLogReplicator> replicators = new HashMap<String, IPeerLogReplicator>();
    private final RaftConfig config;
    private final IRaftStateStore stateStorage;
    private final IRaftNode.IRaftEventListener listener;
    private final Logger logger;

    PeerLogTracker(String id, RaftConfig config, IRaftStateStore stateStorage, IRaftNode.IRaftEventListener listener, Logger logger) {
        this.id = id;
        this.config = config;
        this.stateStorage = stateStorage;
        this.listener = listener;
        this.logger = logger;
    }

    public void tick() {
        if (this.replicators.values().stream().anyMatch(IPeerLogReplicator::tick)) {
            this.notifyReplicationStatusChange();
        }
    }

    public void startTracking(Set<String> peerIds, boolean notify) {
        boolean changed = false;
        for (String peerId : peerIds) {
            if (this.replicators.putIfAbsent(peerId, new PeerLogReplicator(peerId, this.config, this.stateStorage, this.logger)) != null) continue;
            changed = true;
        }
        if (changed && notify) {
            this.notifyReplicationStatusChange();
        }
    }

    public boolean isTracking(String peerId) {
        return this.replicators.containsKey(peerId);
    }

    public Set<String> peers() {
        return Collections.unmodifiableSet(this.replicators.keySet());
    }

    public void stopTracking(Set<String> peerIds) {
        boolean notity = false;
        for (String peerId : peerIds) {
            if (this.replicators.remove(peerId) == null) continue;
            notity = true;
        }
        if (notity) {
            this.notifyReplicationStatusChange();
        }
    }

    public void stopTracking(Predicate<String> predicate, boolean notify) {
        if (this.replicators.keySet().removeIf(predicate) && notify) {
            this.notifyReplicationStatusChange();
        }
    }

    public long matchIndex(String peerId) {
        return this.replicators.get(peerId).matchIndex();
    }

    public long nextIndex(String peerId) {
        return this.replicators.get(peerId).nextIndex();
    }

    public RaftNodeSyncState status(String peerId) {
        return this.replicators.get(peerId).status();
    }

    public long catchupRate(String peerId) {
        return this.replicators.get(peerId).catchupRate();
    }

    public boolean pauseReplicating(String peerId) {
        return this.replicators.get(peerId).pauseReplicating();
    }

    public boolean needHeartbeat(String peerId) {
        return this.replicators.get(peerId).needHeartbeat();
    }

    public void backoff(String peerId, long peerRejectedIndex, long peerLastIndex) {
        if (this.replicators.get(peerId).backoff(peerRejectedIndex, peerLastIndex)) {
            this.notifyReplicationStatusChange();
        }
    }

    public void confirmMatch(String peerId, long peerLastIndex) {
        if (this.replicators.get(peerId).confirmMatch(peerLastIndex)) {
            this.notifyReplicationStatusChange();
        }
    }

    public void replicateBy(String peerId, long endIndex) {
        if (this.replicators.get(peerId).replicateBy(endIndex)) {
            this.notifyReplicationStatusChange();
        }
    }

    void notifyReplicationStatusChange() {
        Map<String, RaftNodeSyncState> replicationStatusMap = this.replicators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IPeerLogReplicator)entry.getValue()).status()));
        this.listener.onEvent(new SyncStateChangedEvent(this.id, replicationStatusMap));
    }
}

