/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.stats;

import com.google.common.collect.Maps;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.base.util.AsyncRunner;
import org.apache.bifromq.basekv.store.stats.IStatsCollector;

public abstract class StatsCollector
implements IStatsCollector {
    private final Duration interval;
    private final AsyncRunner executor;
    private final BehaviorSubject<Map<String, Double>> statsSubject = BehaviorSubject.create();
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile long lastScrapAt = 0L;

    public StatsCollector(Duration interval, Executor executor) {
        this.interval = interval;
        this.executor = new AsyncRunner("basekv.runner.statscollect", executor, new String[0]);
    }

    @Override
    public final Observable<Map<String, Double>> collect() {
        return this.statsSubject.distinctUntilChanged();
    }

    @Override
    public final void tick() {
        if (!this.closed.get() && this.interval.compareTo(Duration.ofNanos(System.nanoTime() - this.lastScrapAt)) <= 0) {
            this.executor.add(() -> {
                if (this.closed.get()) {
                    if (!this.statsSubject.hasComplete()) {
                        this.statsSubject.onComplete();
                    }
                    return;
                }
                HashMap stats = Maps.newHashMap();
                this.scrap(stats);
                this.statsSubject.onNext((Object)stats);
                this.lastScrapAt = System.nanoTime();
            });
        }
    }

    @Override
    public final CompletionStage<Void> stop() {
        if (this.closed.compareAndSet(false, true)) {
            this.executor.add(() -> {
                if (!this.statsSubject.hasComplete()) {
                    this.statsSubject.onComplete();
                }
            });
        }
        return this.executor.awaitDone();
    }

    protected abstract void scrap(Map<String, Double> var1);
}

