/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.utils.BoundaryUtil;

public class KVUtil {
    public static ByteString toByteString(int i) {
        return UnsafeByteOperations.unsafeWrap((byte[])KVUtil.toBytes(i));
    }

    public static ByteString toByteString(long l) {
        return UnsafeByteOperations.unsafeWrap((byte[])KVUtil.toBytes(l));
    }

    public static ByteString toByteString(KVRangeId kvRangeId) {
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)ByteBuffer.allocate(16).putLong(kvRangeId.getEpoch()).putLong(kvRangeId.getId()).flip());
    }

    public static ByteString toByteStringNativeOrder(long l) {
        return UnsafeByteOperations.unsafeWrap((byte[])KVUtil.toBytesNativeOrder(l));
    }

    private static byte[] toBytes(long l) {
        return ByteBuffer.allocate(8).putLong(l).array();
    }

    private static byte[] toBytes(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    private static byte[] toBytesNativeOrder(long l) {
        return ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(l).array();
    }

    public static int toInt(ByteString b) {
        assert (b.size() == 4);
        ByteBuffer buffer = b.asReadOnlyByteBuffer();
        return buffer.getInt();
    }

    public static long toLong(ByteString b) {
        assert (b.size() == 8);
        ByteBuffer buffer = b.asReadOnlyByteBuffer();
        return buffer.getLong();
    }

    public static long toLong(byte[] b) {
        return KVUtil.toLong(UnsafeByteOperations.unsafeWrap((byte[])b));
    }

    public static long toLongNativeOrder(ByteString b) {
        assert (b.size() == 8);
        ByteBuffer buffer = b.asReadOnlyByteBuffer().order(ByteOrder.nativeOrder());
        return buffer.getLong();
    }

    public static KVRangeId toKVRangeId(ByteString b) {
        assert (b.size() == 16);
        ByteBuffer buffer = b.asReadOnlyByteBuffer();
        return KVRangeId.newBuilder().setEpoch(buffer.getLong()).setId(buffer.getLong()).build();
    }

    public static KVRangeId cap(KVRangeId kvRangeId) {
        ByteBuffer upper = ByteBuffer.wrap(BoundaryUtil.upperBound((byte[])ByteBuffer.allocate(16).putLong(kvRangeId.getEpoch()).putLong(kvRangeId.getId()).array()));
        return KVRangeId.newBuilder().setEpoch(upper.getLong()).setId(upper.getLong()).build();
    }

    public static ByteString concat(ByteString ... keys) {
        ByteString finalBS = ByteString.EMPTY;
        for (ByteString key : keys) {
            finalBS = finalBS.concat(key);
        }
        return finalBS;
    }
}

