/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.interceptor;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.baserpc.MetadataKeys;
import org.apache.bifromq.baserpc.RPCContext;
import org.apache.bifromq.baserpc.client.loadbalancer.Constants;
import org.apache.bifromq.baserpc.proto.PipelineMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAwareClientInterceptor
implements ClientInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAwareClientInterceptor.class);
    private final String serviceUniqueName;

    public TenantAwareClientInterceptor() {
        this(null);
    }

    public TenantAwareClientInterceptor(String serviceUniqueName) {
        this.serviceUniqueName = serviceUniqueName;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(MetadataKeys.TENANT_ID_META_KEY, (Object)((String)RPCContext.TENANT_ID_CTX_KEY.get()));
                if (RPCContext.DESIRED_SERVER_ID_CTX_KEY.get() != null) {
                    headers.put(Constants.DESIRED_SERVER_META_KEY, (Object)((String)RPCContext.DESIRED_SERVER_ID_CTX_KEY.get()));
                }
                if (RPCContext.CUSTOM_METADATA_CTX_KEY.get() != null) {
                    headers.put(MetadataKeys.CUSTOM_METADATA_META_KEY, (Object)PipelineMetadata.newBuilder().putAllEntry((Map)RPCContext.CUSTOM_METADATA_CTX_KEY.get()).build().toByteArray());
                }
                super.start(responseListener, headers);
            }
        };
    }
}

