/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.inject.Singleton;
import java.io.File;
import org.apache.bifromq.baserpc.server.IRPCServer;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.ServerSSLContextConfig;
import org.apache.bifromq.starter.module.SSLUtil;
import org.apache.bifromq.starter.utils.ResourceUtil;

public class RPCServerBuilderModule
extends AbstractModule {
    protected void configure() {
        this.bind(RPCServerBuilder.class).toProvider(RPCServerBuilderProvider.class).in(Singleton.class);
    }

    private static class RPCServerBuilderProvider
    implements Provider<RPCServerBuilder> {
        private final StandaloneConfig config;
        private final IRPCServiceTrafficService trafficService;

        @Inject
        private RPCServerBuilderProvider(StandaloneConfig config, IRPCServiceTrafficService trafficService) {
            this.config = config;
            this.trafficService = trafficService;
        }

        public RPCServerBuilder get() {
            RPCServerBuilder rpcServerBuilder = IRPCServer.newBuilder().host(this.config.getRpcConfig().getHost()).port(this.config.getRpcConfig().getPort()).workerThreads(this.config.getRpcConfig().getServerEventLoopThreads()).trafficService(this.trafficService);
            if (this.config.getRpcConfig().isEnableSSL()) {
                rpcServerBuilder.sslContext(this.buildRPCServerSslContext(this.config.getRpcConfig().getServerSSLConfig()));
            }
            return rpcServerBuilder;
        }

        private SslContext buildRPCServerSslContext(ServerSSLContextConfig config) {
            try {
                SslProvider sslProvider = SSLUtil.defaultSslProvider();
                SslContextBuilder sslCtxBuilder = GrpcSslContexts.forServer((File)ResourceUtil.loadFile(config.getCertFile()), (File)ResourceUtil.loadFile(config.getKeyFile())).clientAuth(config.getClientAuth()).sslProvider(sslProvider);
                if (Strings.isNullOrEmpty((String)config.getTrustCertsFile())) {
                    sslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                } else {
                    sslCtxBuilder.trustManager(ResourceUtil.loadFile(config.getTrustCertsFile()));
                }
                if (sslProvider == SslProvider.JDK) {
                    sslCtxBuilder.sslContextProvider(SSLUtil.findJdkProvider());
                }
                return sslCtxBuilder.build();
            }
            catch (Throwable e) {
                throw new RuntimeException("Fail to initialize server SSLContext", e);
            }
        }
    }
}

