/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.hugegraph.HugeFactory;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.auth.StandardAuthenticator;
import org.apache.hugegraph.backend.store.BackendStoreInfo;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.dist.RegisterUtil;
import org.apache.hugegraph.meta.PdMetaDriver;
import org.apache.hugegraph.util.ConfigUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.slf4j.Logger;

public class InitStore {
    private static final Logger LOG = Log.logger(InitStore.class);
    private static final int RETRIES = 10;
    private static final long RETRY_INTERVAL = 5000L;
    private static final MultiValueMap EXCEPTIONS = new MultiValueMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"HugeGraph init-store need to pass the config file of RestServer, like: conf/rest-server.properties", (Object[])new Object[0]);
        E.checkArgument((boolean)args[0].endsWith(".properties"), (String)"Expect the parameter is properties config file.", (Object[])new Object[0]);
        String restConf = args[0];
        RegisterUtil.registerBackends();
        RegisterUtil.registerPlugins();
        RegisterUtil.registerServer();
        HugeConfig restServerConfig = new HugeConfig(restConf);
        PdMetaDriver.PDAuthConfig.setAuthority((String)"hg", (String)"");
        String graphsDir = (String)restServerConfig.get((TypedOption)ServerOptions.GRAPHS);
        Map graph2ConfigPaths = ConfigUtil.scanGraphsDir((String)graphsDir);
        ArrayList<HugeGraph> graphs = new ArrayList<HugeGraph>(graph2ConfigPaths.size());
        try {
            for (Map.Entry entry : graph2ConfigPaths.entrySet()) {
                String configPath = (String)entry.getValue();
                HugeConfig config = new HugeConfig(configPath);
                if (Objects.equals(config.get((TypedOption)CoreOptions.BACKEND), "hstore")) continue;
                graphs.add(InitStore.initGraph(configPath));
            }
            StandardAuthenticator.initAdminUserIfNeeded((String)restConf);
        }
        finally {
            for (HugeGraph graph : graphs) {
                graph.close();
            }
            HugeFactory.shutdown((long)30L, (boolean)true);
        }
    }

    private static HugeGraph initGraph(String configPath) throws Exception {
        LOG.info("Init graph with config file: {}", (Object)configPath);
        HugeConfig config = new HugeConfig(configPath);
        config.setProperty(CoreOptions.RAFT_MODE.name(), (Object)"false");
        HugeGraph graph = (HugeGraph)GraphFactory.open((Configuration)config);
        try {
            BackendStoreInfo backendStoreInfo = graph.backendStoreInfo();
            if (backendStoreInfo.exists()) {
                backendStoreInfo.checkVersion();
                graph.initSystemInfo();
                LOG.info("Skip init-store due to the backend store of '{}' had been initialized", (Object)graph.name());
            } else {
                InitStore.initBackend(graph);
            }
        }
        catch (Throwable e) {
            graph.close();
            throw e;
        }
        return graph;
    }

    private static void initBackend(HugeGraph graph) throws InterruptedException {
        int retries = 10;
        while (true) {
            try {
                graph.initBackend();
            }
            catch (Exception e) {
                String clz = e.getClass().getSimpleName();
                String message = e.getMessage();
                if (EXCEPTIONS.containsKey((Object)clz) && retries > 0) {
                    Collection keywords = EXCEPTIONS.getCollection((Object)clz);
                    for (String keyword : keywords) {
                        if (!message.contains(keyword)) continue;
                        break;
                    }
                } else {
                    throw e;
                }
                LOG.info("Init failed with exception '{} : {}', retry  {}...", new Object[]{clz, message, 10 - retries + 1});
                Thread.sleep(5000L);
                if (retries-- > 0) continue;
            }
            break;
        }
    }

    static {
        EXCEPTIONS.put((Object)"OperationTimedOutException", (Object)"Timed out waiting for server response");
        EXCEPTIONS.put((Object)"NoHostAvailableException", (Object)"All host(s) tried for query failed");
        EXCEPTIONS.put((Object)"InvalidQueryException", (Object)"does not exist");
        EXCEPTIONS.put((Object)"InvalidQueryException", (Object)"unconfigured table");
    }
}

