/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.pd.client.interceptor.AuthenticationException;

public final class PDConfig {
    private String serverHost = "localhost:9000";
    private long grpcTimeOut = 60000L;
    private boolean enablePDNotify = false;
    private boolean enableCache = false;
    private String authority = "DEFAULT";
    private String userName = "store";
    private static final int GRPC_DEFAULT_MAX_INBOUND_MESSAGE_SIZE = 0x40000000;
    private static final int GRPC_DEFAULT_MAX_OUTBOUND_MESSAGE_SIZE = 0x40000000;
    private static int inboundMessageSize = 0x40000000;
    private static int outboundMessageSize = 0x40000000;

    private PDConfig() {
    }

    public static PDConfig of() {
        return new PDConfig();
    }

    public static PDConfig of(String serverHost) {
        PDConfig config = new PDConfig();
        config.serverHost = serverHost;
        return config;
    }

    public static PDConfig of(String serverHost, long timeOut) {
        PDConfig config = new PDConfig();
        config.serverHost = serverHost;
        config.grpcTimeOut = timeOut;
        return config;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public long getGrpcTimeOut() {
        return this.grpcTimeOut;
    }

    public void setGrpcTimeOut(long grpcTimeOut) {
        this.grpcTimeOut = grpcTimeOut;
    }

    @Deprecated
    public PDConfig setEnablePDNotify(boolean enablePDNotify) {
        this.enablePDNotify = enablePDNotify;
        this.enableCache = enablePDNotify;
        return this;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public PDConfig setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
        return this;
    }

    public String toString() {
        return "PDConfig{serverHost='" + this.serverHost + "'}";
    }

    public PDConfig setAuthority(String userName, String pwd) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return this;
        }
        this.userName = userName;
        String auth = userName + ":" + pwd;
        this.authority = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAuthority() {
        if (StringUtils.isEmpty((CharSequence)this.authority)) {
            throw new AuthenticationException("invalid basic authentication info");
        }
        return this.authority;
    }

    public static int getInboundMessageSize() {
        return inboundMessageSize;
    }

    public static void setInboundMessageSize(int inboundMessageSize) {
        PDConfig.inboundMessageSize = inboundMessageSize;
    }

    public static int getOutboundMessageSize() {
        return outboundMessageSize;
    }

    public static void setOutboundMessageSize(int outboundMessageSize) {
        PDConfig.outboundMessageSize = outboundMessageSize;
    }
}

