/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.rocksdb.Priority;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksEnv;
import org.rocksdb.RocksObject;
import org.rocksdb.ThreadStatus;

public abstract class Env
extends RocksObject {
    private static final AtomicReference<RocksEnv> SINGULAR_DEFAULT_ENV = new AtomicReference<Object>(null);

    public static Env getDefault() {
        RocksEnv rocksEnv;
        RocksEnv rocksEnv2 = null;
        while ((rocksEnv = SINGULAR_DEFAULT_ENV.get()) == null) {
            if (rocksEnv2 == null) {
                RocksDB.loadLibrary();
                rocksEnv2 = new RocksEnv(Env.getDefaultEnvInternal());
                rocksEnv2.disOwnNativeHandle();
            }
            SINGULAR_DEFAULT_ENV.compareAndSet(null, rocksEnv2);
        }
        return rocksEnv;
    }

    public Env setBackgroundThreads(int n) {
        return this.setBackgroundThreads(n, Priority.LOW);
    }

    public int getBackgroundThreads(Priority priority) {
        return this.getBackgroundThreads(this.nativeHandle_, priority.getValue());
    }

    public Env setBackgroundThreads(int n, Priority priority) {
        this.setBackgroundThreads(this.nativeHandle_, n, priority.getValue());
        return this;
    }

    public int getThreadPoolQueueLen(Priority priority) {
        return this.getThreadPoolQueueLen(this.nativeHandle_, priority.getValue());
    }

    public Env incBackgroundThreadsIfNeeded(int n, Priority priority) {
        this.incBackgroundThreadsIfNeeded(this.nativeHandle_, n, priority.getValue());
        return this;
    }

    public Env lowerThreadPoolIOPriority(Priority priority) {
        this.lowerThreadPoolIOPriority(this.nativeHandle_, priority.getValue());
        return this;
    }

    public Env lowerThreadPoolCPUPriority(Priority priority) {
        this.lowerThreadPoolCPUPriority(this.nativeHandle_, priority.getValue());
        return this;
    }

    public List<ThreadStatus> getThreadList() throws RocksDBException {
        return Arrays.asList(this.getThreadList(this.nativeHandle_));
    }

    Env(long l) {
        super(l);
    }

    private static native long getDefaultEnvInternal();

    private native void setBackgroundThreads(long var1, int var3, byte var4);

    private native int getBackgroundThreads(long var1, byte var3);

    private native int getThreadPoolQueueLen(long var1, byte var3);

    private native void incBackgroundThreadsIfNeeded(long var1, int var3, byte var4);

    private native void lowerThreadPoolIOPriority(long var1, byte var3);

    private native void lowerThreadPoolCPUPriority(long var1, byte var3);

    private native ThreadStatus[] getThreadList(long var1) throws RocksDBException;
}

