/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import org.gridkit.jvmtool.agent.SjkAgentLocator;
import org.gridkit.lab.jvm.attach.AttachManager;
import org.gridkit.lab.jvm.attach.JavaProcessDetails;

public class SjkAgentHelper {
    private static final String SJK_AGENT_PROP_FALLBACK = "sjk.agent.prop.fallback";
    private static final int JNI_ENOMEM = -4;
    private static final int ATTACH_ERROR_BADJAR = 100;
    private static final int ATTACH_ERROR_NOTONCP = 101;
    private static final int ATTACH_ERROR_STARTFAIL = 102;
    private static boolean TRACE = false;

    public static void enableTrace(boolean trace) {
        TRACE = trace;
    }

    public static Properties agentCommand(long pid, Class<?> cmdClass, String args, long timeoutMS) throws IOException {
        int code;
        String out;
        JavaProcessDetails pd = AttachManager.getDetails((long)pid);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String path = SjkAgentLocator.getJarPath();
        if (TRACE) {
            System.out.println("Use agent JAR: " + path);
        }
        Object[] agentArgs = new String[]{"instrument", "false", path + "=" + cmdClass.getName() + ":" + args};
        if (TRACE) {
            System.out.println("Attach command: " + Arrays.toString(agentArgs));
        }
        pd.sendAttachCommand("load", agentArgs, (OutputStream)bos, timeoutMS);
        if (TRACE) {
            System.out.println("Attach command result: " + new String(bos.toByteArray()));
        }
        if ((out = new String(bos.toByteArray())).startsWith("return code: ")) {
            out = out.substring("return code: ".length());
        }
        if ((code = Integer.valueOf(out.trim()).intValue()) != 0) {
            switch (code) {
                case -4: {
                    throw new RuntimeException("Insuffient memory");
                }
                case 100: {
                    throw new RuntimeException("Agent JAR not found or no Agent-Class attribute");
                }
                case 101: {
                    throw new RuntimeException("Unable to add JAR file to system class path");
                }
                case 102: {
                    throw new RuntimeException("Agent JAR loaded but agent failed to initialize");
                }
            }
            throw new RuntimeException("Failed to load agent - unknown reason: " + code);
        }
        Properties prop = pd.getSystemProperties();
        if ("true".equalsIgnoreCase(prop.getProperty(SJK_AGENT_PROP_FALLBACK))) {
            return prop;
        }
        return pd.getAgentProperties();
    }
}

