/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import com.huaban.analysis.jieba.JiebaSegmenter;
import com.huaban.analysis.jieba.SegToken;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class JiebaAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.of((Object)"SEARCH", (Object)"INDEX");
    private static final JiebaSegmenter JIEBA_SEGMENTER = new JiebaSegmenter();
    private final JiebaSegmenter.SegMode segMode;

    public JiebaAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for jieba analyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        this.segMode = JiebaSegmenter.SegMode.valueOf((String)mode);
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        for (SegToken token : JIEBA_SEGMENTER.process(text, this.segMode)) {
            result.add(token.word);
        }
        return result;
    }
}

