/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.type.Nameable;
import org.apache.hugegraph.util.E;

public class ResourceObject<V> {
    private final String graphSpace;
    private final String graph;
    private final ResourceType type;
    private final V operated;

    public ResourceObject(String graphSpace, String graph, ResourceType type, V operated) {
        E.checkNotNull((Object)graphSpace, (String)"graphSpace");
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)((Object)type), (String)"type");
        E.checkNotNull(operated, (String)"operated");
        this.graphSpace = graphSpace;
        this.graph = graph;
        this.type = type;
        this.operated = operated;
    }

    public static ResourceObject<SchemaElement> of(String graphSpace, String graph, SchemaElement elem) {
        ResourceType resType = ResourceType.from(elem.type());
        return new ResourceObject<SchemaElement>(graphSpace, graph, resType, elem);
    }

    public String graph() {
        return this.graph;
    }

    public ResourceType type() {
        return this.type;
    }

    public V operated() {
        return this.operated;
    }

    public static ResourceObject<SchemaElement> of(String graph, SchemaElement elem) {
        return ResourceObject.of("DEFAULT", graph, elem);
    }

    public static ResourceObject<HugeElement> of(String graphSpace, String graph, HugeElement elem) {
        ResourceType resType = ResourceType.from(elem.type());
        return new ResourceObject<HugeElement>(graphSpace, graph, resType, elem);
    }

    public static ResourceObject<HugeElement> of(String graph, HugeElement elem) {
        return ResourceObject.of("DEFAULT", graph, elem);
    }

    public static ResourceObject<SchemaDefine.AuthElement> of(String graphSpace, String graph, SchemaDefine.AuthElement elem) {
        return new ResourceObject<SchemaDefine.AuthElement>(graphSpace, graph, elem.type(), elem);
    }

    public static ResourceObject<SchemaDefine.AuthElement> of(String graph, SchemaDefine.AuthElement elem) {
        return ResourceObject.of("DEFAULT", graph, elem);
    }

    public static ResourceObject<?> of(String graphSpace, String graph, ResourceType type, Nameable elem) {
        return new ResourceObject<Nameable>(graphSpace, graph, type, elem);
    }

    public static ResourceObject<?> of(String graph, ResourceType type, Nameable elem) {
        return ResourceObject.of("DEFAULT", graph, type, elem);
    }

    public String graphSpace() {
        return this.graphSpace;
    }

    public String toString() {
        Object operated = this.operated;
        if (this.type.isAuth()) {
            operated = ((SchemaDefine.AuthElement)this.operated).idString();
        }
        String typeStr = this.type.toString();
        String operatedStr = operated.toString();
        int capacity = this.graph.length() + typeStr.length() + operatedStr.length() + 36;
        String sb = "Resource{graphspace=" + this.graphSpace + ",graph=" + this.graph + ",type=" + typeStr + ",operated=" + operatedStr + "}";
        return sb;
    }
}

