/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.auth.HugeResource;
import org.apache.hugegraph.auth.HugeTarget;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonProperty;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonMappingException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class RolePermission {
    public static final String ALL = "*";
    public static final RolePermission NONE = RolePermission.role("*", "*", HugePermission.NONE);
    public static final RolePermission ADMIN = RolePermission.role("*", "*", HugePermission.ADMIN);
    public static final String ANY_LABEL = "*";
    public static final String POUND_SEPARATOR = "#";
    private final String defaultGraphSpace = "DEFAULT";
    @JsonProperty(value="roles")
    private final Map<String, Map<String, Map<HugePermission, Map<String, List<HugeResource>>>>> roles;

    public RolePermission() {
        this(new TreeMap<String, Map<String, Map<HugePermission, Map<String, List<HugeResource>>>>>());
    }

    RolePermission(Map<String, Map<String, Map<HugePermission, Map<String, List<HugeResource>>>>> roles) {
        this.roles = roles;
    }

    public static RolePermission all(String graph) {
        return RolePermission.role("*", "*", HugePermission.ADMIN);
    }

    public static RolePermission role(String graphSpace, String graph, HugePermission perm) {
        RolePermission role = new RolePermission();
        if (perm.ordinal() <= HugePermission.EXECUTE.ordinal() && perm.ordinal() >= HugePermission.READ.ordinal()) {
            role.add(graphSpace, graph, perm, HugeResource.ALL_RES);
        } else {
            role.add(graphSpace, graph, perm, null);
        }
        return role;
    }

    public static RolePermission role(String graph, HugePermission perm) {
        return RolePermission.role(RolePermission.admin().defaultGraphSpace, graph, perm);
    }

    public static RolePermission none() {
        return RolePermission.role("*", "*", HugePermission.NONE);
    }

    public static RolePermission admin() {
        return RolePermission.role("*", "*", HugePermission.ADMIN);
    }

    public static boolean isAdmin(RolePermission role) {
        return role.isAdmin();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RolePermission)) {
            return false;
        }
        RolePermission other = (RolePermission)object;
        return Objects.equals(this.roles, other.roles);
    }

    public int hashCode() {
        return Objects.hash(this.roles);
    }

    public String toString() {
        return this.roles.toString();
    }

    public String toJson() {
        return JsonUtil.toJson(this);
    }

    public static RolePermission fromJson(Object json) {
        RolePermission role;
        if (json instanceof String) {
            role = JsonUtil.fromJson((String)json, RolePermission.class);
        } else {
            E.checkArgument((boolean)(json instanceof RolePermission), (String)"Invalid role value: %s", (Object[])new Object[]{json});
            role = (RolePermission)json;
        }
        return role;
    }

    public Map<String, Map<String, Map<HugePermission, Map<String, List<HugeResource>>>>> roles() {
        return this.roles;
    }

    protected Map<String, Map<String, Map<HugePermission, Map<String, List<HugeResource>>>>> map() {
        return Collections.unmodifiableMap(this.roles);
    }

    protected void add(String graphSpace, String graph, String action, Map<String, List<HugeResource>> resources) {
        this.add(graphSpace, graph, HugePermission.valueOf(action), resources);
    }

    protected void add(String graph, HugePermission action, Map<String, List<HugeResource>> resources) {
        this.add("DEFAULT", graph, action, resources);
    }

    protected void add(String graphSpace, String graph, HugePermission action, Map<String, List<HugeResource>> resources) {
        Map<HugePermission, Map<String, List<HugeResource>>> permissions;
        if (action != HugePermission.ADMIN && action != HugePermission.SPACE && (resources == null || resources == HugeTarget.EMPTY)) {
            return;
        }
        Map<String, Map<HugePermission, Map<String, List<HugeResource>>>> graphPermissions = this.roles.get(graphSpace);
        if (graphPermissions == null) {
            graphPermissions = new TreeMap<String, Map<HugePermission, Map<String, List<HugeResource>>>>();
        }
        if ((permissions = graphPermissions.get(graph)) == null) {
            permissions = new TreeMap<HugePermission, Map<String, List<HugeResource>>>();
            LinkedHashMap<String, List<HugeResource>> orderedResources = new LinkedHashMap<String, List<HugeResource>>();
            if (resources != null) {
                orderedResources.putAll(resources);
            }
            permissions.put(action, orderedResources);
            graphPermissions.put(graph, permissions);
        } else {
            Map<String, List<HugeResource>> mergedResources = permissions.get(action);
            if (mergedResources == null) {
                mergedResources = new LinkedHashMap<String, List<HugeResource>>();
                permissions.put(action, mergedResources);
            }
            for (Map.Entry<String, List<HugeResource>> entry : resources.entrySet()) {
                String typeLabel = entry.getKey();
                List<HugeResource> resourcesList = mergedResources.get(typeLabel);
                if (resourcesList != null) {
                    resourcesList.addAll((Collection<HugeResource>)entry.getValue());
                    continue;
                }
                mergedResources.put(typeLabel, entry.getValue());
            }
            if (mergedResources.isEmpty()) {
                permissions.put(action, null);
            }
        }
        this.roles.put(graphSpace, graphPermissions);
    }

    protected boolean contains(RolePermission other) {
        if (this.isAdmin()) {
            return true;
        }
        for (Map.Entry<String, Map<String, Map<HugePermission, Map<String, List<HugeResource>>>>> e1 : other.roles.entrySet()) {
            String graphSpace = e1.getKey();
            Map<String, Map<HugePermission, Map<String, List<HugeResource>>>> resGraph = this.roles.get(graphSpace);
            if (resGraph == null) {
                return false;
            }
            for (Map.Entry<String, Map<HugePermission, Map<String, List<HugeResource>>>> e2 : e1.getValue().entrySet()) {
                Map<HugePermission, Map<String, List<HugeResource>>> resPerm = resGraph.get(e2.getKey());
                if (resPerm == null) {
                    return false;
                }
                for (Map.Entry<HugePermission, Map<String, List<HugeResource>>> e3 : e2.getValue().entrySet()) {
                    Map<String, List<HugeResource>> resType = resPerm.get(e3.getKey());
                    if (resType == null) {
                        return false;
                    }
                    for (Map.Entry<String, List<HugeResource>> e4 : e3.getValue().entrySet()) {
                        String[] typeAndLabel = e4.getKey().split(POUND_SEPARATOR);
                        ResourceType requiredType = ResourceType.valueOf(typeAndLabel[0]);
                        boolean checkLabel = requiredType.isGraphOrSchema();
                        for (HugeResource r : e4.getValue()) {
                            boolean contains = false;
                            block5: for (Map.Entry<String, List<HugeResource>> ressMap : resType.entrySet()) {
                                List<HugeResource> ress;
                                String[] key = ressMap.getKey().split(POUND_SEPARATOR);
                                ResourceType ressType = ResourceType.valueOf(key[0]);
                                if (!ressType.match(requiredType) || (ress = ressMap.getValue()) == null) continue;
                                if (!checkLabel) {
                                    contains = true;
                                    break;
                                }
                                if (!key[1].equals("*") && !typeAndLabel[1].matches(key[1])) continue;
                                if (!requiredType.isGraph()) {
                                    contains = true;
                                    break;
                                }
                                for (HugeResource res : ress) {
                                    if (!res.matchProperties(r)) continue;
                                    contains = true;
                                    continue block5;
                                }
                            }
                            if (contains) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean isAdmin() {
        return this.roles.containsKey("*") && this.roles.get("*").containsKey("*") && this.roles.get("*").get("*").containsKey(HugePermission.ADMIN);
    }

    public static RolePermission builtin(RolePermission role) {
        E.checkNotNull((Object)role, (String)"role");
        if (role == ADMIN || role.equals(ADMIN)) {
            return ADMIN;
        }
        if (role == NONE || role.equals(NONE)) {
            return NONE;
        }
        return role;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(RolePermission.class, (JsonSerializer)new RolePermissionSer());
        module.addDeserializer(RolePermission.class, (JsonDeserializer)new RolePermissionDeser());
        JsonUtil.registerModule((Module)module);
    }

    private static class RolePermissionDeser
    extends StdDeserializer<RolePermission> {
        private static final long serialVersionUID = -2038234657843260957L;

        public RolePermissionDeser() {
            super(RolePermission.class);
        }

        public RolePermission deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            TypeReference<TreeMap<String, TreeMap<String, TreeMap<HugePermission, TreeMap<String, List<HugeResource>>>>>> type = new TypeReference<TreeMap<String, TreeMap<String, TreeMap<HugePermission, TreeMap<String, List<HugeResource>>>>>>(){};
            if ("roles".equals(parser.nextFieldName())) {
                parser.nextValue();
                return new RolePermission((Map)parser.readValueAs((TypeReference)type));
            }
            throw JsonMappingException.from((JsonParser)parser, (String)"Expect field roles");
        }
    }

    private static class RolePermissionSer
    extends StdSerializer<RolePermission> {
        private static final long serialVersionUID = -2533310506459479383L;

        public RolePermissionSer() {
            super(RolePermission.class);
        }

        public void serialize(RolePermission role, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeObjectField("roles", role.roles);
            generator.writeEndObject();
        }
    }
}

