/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft;

import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;

public final class StoreCommand {
    public static final int HEADER_SIZE = 2;
    private final RaftRequests.StoreType type;
    private final RaftRequests.StoreAction action;
    private final byte[] data;
    private final boolean forwarded;

    public StoreCommand(RaftRequests.StoreType type, RaftRequests.StoreAction action, byte[] data) {
        this(type, action, data, false);
    }

    public StoreCommand(RaftRequests.StoreType type, RaftRequests.StoreAction action, byte[] data, boolean forwarded) {
        this.type = type;
        this.action = action;
        if (data == null) {
            this.data = new byte[2];
        } else {
            assert (data.length >= 2);
            this.data = data;
        }
        this.data[0] = (byte)this.type.getNumber();
        this.data[1] = (byte)this.action.getNumber();
        this.forwarded = forwarded;
    }

    public RaftRequests.StoreType type() {
        return this.type;
    }

    public RaftRequests.StoreAction action() {
        return this.action;
    }

    public byte[] data() {
        return this.data;
    }

    public boolean forwarded() {
        return this.forwarded;
    }

    public static void writeHeader(BytesBuffer buffer) {
        buffer.write((byte)0);
        buffer.write((byte)0);
    }

    public static byte[] wrap(byte value) {
        byte[] bytes = new byte[3];
        bytes[2] = value;
        return bytes;
    }

    public static StoreCommand fromBytes(byte[] bytes) {
        RaftRequests.StoreType type = RaftRequests.StoreType.valueOf(bytes[0]);
        RaftRequests.StoreAction action = RaftRequests.StoreAction.valueOf(bytes[1]);
        return new StoreCommand(type, action, bytes);
    }

    public String toString() {
        return String.format("StoreCommand{type=%s,action=%s}", this.type.name(), this.action.name());
    }
}

