/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class CountEdgeAlgorithm
extends AbstractAlgorithm {
    @Override
    public String name() {
        return "count_edge";
    }

    @Override
    public String category() {
        return "aggregate";
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.count();
            return object;
        }
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object count() {
            Iterator<Edge> edges = this.edges(null);
            HashMap<String, MutableLong> counts = new HashMap<String, MutableLong>();
            long total = 0L;
            while (edges.hasNext()) {
                Edge edge = edges.next();
                String label = edge.label();
                MutableLong count = (MutableLong)counts.get(label);
                if (count != null) {
                    count.increment();
                } else {
                    counts.put(label, new MutableLong(1L));
                }
                this.updateProgress(++total);
            }
            counts.put("*", new MutableLong(total));
            return JsonUtil.asJson(counts);
        }
    }
}

