/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.schema;

import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.job.schema.IndexLabelRemoveJob;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.LockUtil;

public class OlapPropertyKeyClearJob
extends IndexLabelRemoveJob {
    @Override
    public String type() {
        return "clear_olap";
    }

    @Override
    public Object execute() {
        Id olap = this.schemaId();
        this.params().graphTransaction().clearOlapPk(olap);
        OlapPropertyKeyClearJob.clearIndexLabel(this.params(), olap);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearIndexLabel(HugeGraphParams graph, Id id) {
        Id olapIndexLabel = OlapPropertyKeyClearJob.findOlapIndexLabel(graph, id);
        if (olapIndexLabel == null) {
            return;
        }
        GraphTransaction graphTx = graph.graphTransaction();
        ISchemaTransaction schemaTx = graph.schemaTransaction();
        IndexLabel indexLabel = schemaTx.getIndexLabel(olapIndexLabel);
        if (indexLabel == null) {
            return;
        }
        LockUtil.Locks locks = new LockUtil.Locks(graph.graph().spaceGraphName());
        try {
            locks.lockWrites("il_delete", olapIndexLabel);
            schemaTx.updateSchemaStatus(indexLabel, SchemaStatus.REBUILDING);
            try {
                graphTx.removeIndex(indexLabel);
                graph.graph().tx().commit();
                schemaTx.updateSchemaStatus(indexLabel, SchemaStatus.CREATED);
            }
            catch (Throwable e) {
                schemaTx.updateSchemaStatus(indexLabel, SchemaStatus.INVALID);
                throw e;
            }
        }
        finally {
            locks.unlock();
        }
    }

    protected static Id findOlapIndexLabel(HugeGraphParams graph, Id olap) {
        ISchemaTransaction schemaTx = graph.schemaTransaction();
        for (IndexLabel indexLabel : schemaTx.getIndexLabels()) {
            if (!indexLabel.indexFields().contains(olap)) continue;
            return indexLabel.id();
        }
        return null;
    }
}

