/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.masterelection;

import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.type.define.NodeRole;
import org.apache.hugegraph.util.E;

public final class GlobalMasterInfo {
    private static final NodeInfo NO_MASTER = new NodeInfo(false, "");
    private volatile boolean supportElection = false;
    private volatile NodeInfo masterNodeInfo;
    private volatile Id nodeId;
    private volatile NodeRole nodeRole;

    public GlobalMasterInfo() {
        this(NO_MASTER);
    }

    public GlobalMasterInfo(NodeInfo masterInfo) {
        this.masterNodeInfo = masterInfo;
        this.nodeId = null;
        this.nodeRole = null;
    }

    public void supportElection(boolean featureSupport) {
        this.supportElection = featureSupport;
    }

    public boolean supportElection() {
        return this.supportElection;
    }

    public void resetMasterInfo() {
        this.masterNodeInfo = NO_MASTER;
    }

    public void masterInfo(boolean isMaster, String nodeUrl) {
        this.masterNodeInfo = new NodeInfo(isMaster, nodeUrl);
    }

    public NodeInfo masterInfo() {
        return this.masterNodeInfo;
    }

    public Id nodeId() {
        return this.nodeId;
    }

    public NodeRole nodeRole() {
        return this.nodeRole;
    }

    public void initNodeId(Id id) {
        this.nodeId = id;
    }

    public void initNodeRole(NodeRole role) {
        E.checkArgument((role != null ? 1 : 0) != 0, (String)"The server role can't be null", (Object[])new Object[0]);
        E.checkArgument((this.nodeRole == null ? 1 : 0) != 0, (String)"The server role can't be init twice", (Object[])new Object[0]);
        this.nodeRole = role;
    }

    public void changeNodeRole(NodeRole role) {
        E.checkArgument((role != null ? 1 : 0) != 0, (String)"The server role can't be null", (Object[])new Object[0]);
        this.nodeRole = role;
    }

    public static GlobalMasterInfo master(String nodeId) {
        NodeInfo masterInfo = new NodeInfo(true, nodeId);
        GlobalMasterInfo nodeInfo = new GlobalMasterInfo(masterInfo);
        nodeInfo.nodeId = IdGenerator.of(nodeId);
        nodeInfo.nodeRole = NodeRole.MASTER;
        return nodeInfo;
    }

    public static class NodeInfo {
        private final boolean isMaster;
        private final String nodeUrl;

        public NodeInfo(boolean isMaster, String url) {
            this.isMaster = isMaster;
            this.nodeUrl = url;
        }

        public boolean isMaster() {
            return this.isMaster;
        }

        public String nodeUrl() {
            return this.nodeUrl;
        }
    }
}

