/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.impl.id;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.hugegraph.backend.cache.CachedBackendStore;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;

public class QueryIdOffHeap
extends CachedBackendStore.QueryId
implements OffHeapObject {
    private ByteBuf queryOffHeap;

    public QueryIdOffHeap(MemoryPool memoryPool, Query q) {
        super(q);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    @Override
    public Object zeroCopyReadFromByteBuf() {
        try {
            CachedBackendStore.QueryId queryId = new CachedBackendStore.QueryId(this.queryOffHeap.toString(StandardCharsets.UTF_8), this.hashCode);
            return queryId;
        }
        finally {
            this.queryOffHeap.resetReaderIndex();
        }
    }

    @Override
    public void serializeSelfToByteBuf(MemoryPool memoryPool) {
        byte[] stringBytes = this.query.getBytes(StandardCharsets.UTF_8);
        this.queryOffHeap = (ByteBuf)memoryPool.requireMemory(stringBytes.length, memoryPool);
        this.queryOffHeap.markReaderIndex();
        this.queryOffHeap.writeBytes(stringBytes);
    }

    @Override
    public void releaseOriginalVarsOnHeap() {
        this.query = null;
    }

    @Override
    public List<ByteBuf> getAllMemoryBlock() {
        return Collections.singletonList(this.queryOffHeap);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof QueryIdOffHeap)) {
            return false;
        }
        return this.queryOffHeap.equals((Object)((QueryIdOffHeap)other).queryOffHeap);
    }

    @Override
    public int compareTo(Id o) {
        return this.asString().compareTo(o.asString());
    }

    @Override
    public Object asObject() {
        return this.asString();
    }

    @Override
    public String asString() {
        try {
            String string = this.queryOffHeap.toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            this.queryOffHeap.resetReaderIndex();
        }
    }

    @Override
    public byte[] asBytes() {
        return ByteBufUtil.getBytes((ByteBuf)this.queryOffHeap);
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @Override
    public int length() {
        return this.asString().length();
    }
}

