/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.impl.id;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.jetbrains.annotations.TestOnly;

public class StringIdOffHeap
extends IdGenerator.StringId
implements OffHeapObject {
    private ByteBuf idOffHeap;

    public StringIdOffHeap(MemoryPool memoryPool, String id) {
        super(id);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    public StringIdOffHeap(MemoryPool memoryPool, byte[] bytes) {
        super(bytes);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    @Override
    public Object zeroCopyReadFromByteBuf() {
        try {
            IdGenerator.StringId stringId = new IdGenerator.StringId(this.idOffHeap.toString(StandardCharsets.UTF_8));
            return stringId;
        }
        finally {
            this.idOffHeap.resetReaderIndex();
        }
    }

    @Override
    public void serializeSelfToByteBuf(MemoryPool memoryPool) {
        byte[] stringBytes = this.bytes != null ? this.bytes : this.id.getBytes(StandardCharsets.UTF_8);
        this.idOffHeap = (ByteBuf)memoryPool.requireMemory(stringBytes.length, memoryPool);
        this.idOffHeap.markReaderIndex();
        this.idOffHeap.writeBytes(stringBytes);
    }

    @Override
    public void releaseOriginalVarsOnHeap() {
        this.id = null;
        this.bytes = null;
    }

    @Override
    public List<ByteBuf> getAllMemoryBlock() {
        return Collections.singletonList(this.idOffHeap);
    }

    @Override
    public Object asObject() {
        return this.asString();
    }

    @Override
    public String asString() {
        try {
            String string = this.idOffHeap.toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            this.idOffHeap.resetReaderIndex();
        }
    }

    @Override
    public long asLong() {
        return Long.parseLong(this.asString());
    }

    @Override
    public byte[] asBytes() {
        return ByteBufUtil.getBytes((ByteBuf)this.idOffHeap);
    }

    @Override
    public int length() {
        return this.asString().length();
    }

    @Override
    public int compareTo(Id other) {
        int cmp = IdGenerator.compareType(this, other);
        if (cmp != 0) {
            return cmp;
        }
        return this.asString().compareTo(other.asString());
    }

    @Override
    public int hashCode() {
        return this.idOffHeap.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StringIdOffHeap)) {
            return false;
        }
        return this.idOffHeap.equals((Object)((StringIdOffHeap)other).idOffHeap);
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @TestOnly
    public ByteBuf getIdOffHeap() {
        return this.idOffHeap;
    }
}

