/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.space;

import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.hugegraph.util.E;

public class SchemaTemplate {
    public static SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected Date createTime;
    protected Date updateTime;
    protected String creator;
    private final String name;
    private String schema;

    public SchemaTemplate(String name, String schema) {
        E.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"The name of schema template can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((schema != null && !schema.isEmpty() ? 1 : 0) != 0, (String)"The schema template can't be null or empty", (Object[])new Object[0]);
        this.name = name;
        this.schema = schema;
        this.updateTime = this.createTime = new Date();
    }

    public SchemaTemplate(String name, String schema, Date create, String creator) {
        E.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"The name of schema template can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((schema != null && !schema.isEmpty() ? 1 : 0) != 0, (String)"The schema template can't be null or empty", (Object[])new Object[0]);
        this.name = name;
        this.schema = schema;
        this.updateTime = this.createTime = create;
        this.creator = creator;
    }

    public static SchemaTemplate fromMap(Map<String, String> map) {
        try {
            SchemaTemplate template = new SchemaTemplate(map.get("name"), map.get("schema"), FORMATTER.parse(map.get("create")), map.get("creator"));
            template.updateTime(FORMATTER.parse(map.get("update")));
            return template;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String name() {
        return this.name;
    }

    public String schema() {
        return this.schema;
    }

    public void schema(String schema) {
        this.schema = schema;
    }

    public Date create() {
        return this.createTime;
    }

    public Date createTime() {
        return this.createTime;
    }

    public Date update() {
        return this.updateTime;
    }

    public Date updateTime() {
        return this.updateTime;
    }

    public void create(Date create) {
        this.createTime = create;
    }

    public String creator() {
        return this.creator;
    }

    public void creator(String creator) {
        this.creator = creator;
    }

    public void updateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void refreshUpdateTime() {
        this.updateTime = new Date();
    }

    public Map<String, String> asMap() {
        String createStr = FORMATTER.format(this.createTime);
        String updateStr = FORMATTER.format(this.updateTime);
        return new ImmutableMap.Builder().put((Object)"name", (Object)this.name).put((Object)"schema", (Object)this.schema).put((Object)"create", (Object)createStr).put((Object)"create_time", (Object)createStr).put((Object)"update", (Object)updateStr).put((Object)"update_time", (Object)updateStr).put((Object)"creator", (Object)this.creator).build();
    }
}

