/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.NodeRole;
import org.apache.hugegraph.type.define.SerialEnum;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class HugeServerInfo {
    private static final long EXPIRED_INTERVAL = 10000L;
    private NodeRole role;
    private Date updateTime;
    private int maxLoad;
    private int load;
    private final Id id;
    private transient boolean updated = false;

    public HugeServerInfo(String name, NodeRole role) {
        this(IdGenerator.of(name), role);
    }

    public HugeServerInfo(Id id) {
        this.id = id;
        this.role = NodeRole.WORKER;
        this.maxLoad = 0;
        this.load = 0;
        this.updateTime = DateUtil.now();
    }

    public HugeServerInfo(Id id, NodeRole role) {
        this.id = id;
        this.load = 0;
        this.role = role;
        this.updateTime = DateUtil.now();
    }

    public Id id() {
        return this.id;
    }

    public String name() {
        return this.id.asString();
    }

    public NodeRole role() {
        return this.role;
    }

    public void role(NodeRole role) {
        this.role = role;
    }

    public int maxLoad() {
        return this.maxLoad;
    }

    public void maxLoad(int maxLoad) {
        this.maxLoad = maxLoad;
    }

    public int load() {
        return this.load;
    }

    public void load(int load) {
        this.load = load;
    }

    public void increaseLoad(int delta) {
        this.load += delta;
        this.updated = true;
    }

    public long expireTime() {
        return this.updateTime.getTime() + 10000L;
    }

    public Date updateTime() {
        return this.updateTime;
    }

    public void updateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public boolean alive() {
        long now = DateUtil.now().getTime();
        return this.updateTime != null && this.updateTime.getTime() + 10000L > now;
    }

    public boolean updated() {
        return this.updated;
    }

    public String toString() {
        return String.format("HugeServerInfo(%s)%s", this.id, this.asMap());
    }

    protected boolean property(String key, Object value) {
        switch (key) {
            case "~server_role": {
                this.role = SerialEnum.fromCode(NodeRole.class, (Byte)value);
                break;
            }
            case "~server_max_load": {
                this.maxLoad = (Integer)value;
                break;
            }
            case "~server_load": {
                this.load = (Integer)value;
                break;
            }
            case "~server_update_time": {
                this.updateTime = (Date)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    protected Object[] asArray() {
        E.checkState((this.id != null ? 1 : 0) != 0, (String)"Server id can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(12);
        list.add(T.label);
        list.add(P.SERVER);
        list.add(T.id);
        list.add(this.id);
        list.add("~server_role");
        list.add(this.role.code());
        list.add("~server_max_load");
        list.add(this.maxLoad);
        list.add("~server_load");
        list.add(this.load);
        list.add("~server_update_time");
        list.add(this.updateTime);
        return list.toArray();
    }

    public Map<String, Object> asMap() {
        E.checkState((this.id != null ? 1 : 0) != 0, (String)"Server id can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)P.ID), this.id);
        map.put(Graph.Hidden.unHide((String)P.LABEL), P.SERVER);
        map.put(Graph.Hidden.unHide((String)"~server_role"), this.role);
        map.put(Graph.Hidden.unHide((String)"~server_max_load"), this.maxLoad);
        map.put(Graph.Hidden.unHide((String)"~server_load"), this.load);
        map.put(Graph.Hidden.unHide((String)"~server_update_time"), this.updateTime);
        return map;
    }

    public static HugeServerInfo fromVertex(Vertex vertex) {
        HugeServerInfo serverInfo = new HugeServerInfo((Id)vertex.id());
        Iterator iter = vertex.properties(new String[0]);
        while (iter.hasNext()) {
            VertexProperty prop = (VertexProperty)iter.next();
            serverInfo.property(prop.key(), prop.value());
        }
        return serverInfo;
    }

    public <V> boolean suitableFor(HugeTask<V> task, long now) {
        if (task.computer() != this.role.computer()) {
            return false;
        }
        return this.updateTime.getTime() + 10000L >= now && this.load() + task.load() <= this.maxLoad;
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static final class Schema {
        public static final String SERVER = P.SERVER;
        private final HugeGraphParams graph;

        public Schema(HugeGraphParams graph) {
            this.graph = graph;
        }

        public void initSchemaIfNeeded() {
            if (this.existVertexLabel(SERVER)) {
                return;
            }
            HugeGraph graph = this.graph.graph();
            String[] properties = this.initProperties();
            VertexLabel label = (VertexLabel)graph.schema().vertexLabel(SERVER).properties(properties).useCustomizeStringId().nullableKeys("~server_role", "~server_max_load", "~server_load", "~server_update_time").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addVertexLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~server_role", DataType.BYTE));
            props.add(this.createPropertyKey("~server_max_load", DataType.INT));
            props.add(this.createPropertyKey("~server_load", DataType.INT));
            props.add(this.createPropertyKey("~server_update_time", DataType.DATE));
            return props.toArray(new String[0]);
        }

        public boolean existVertexLabel(String label) {
            return this.graph.schemaTransaction().getVertexLabel(label) != null;
        }

        private String createPropertyKey(String name) {
            return this.createPropertyKey(name, DataType.TEXT);
        }

        private String createPropertyKey(String name, DataType dataType) {
            return this.createPropertyKey(name, dataType, Cardinality.SINGLE);
        }

        private String createPropertyKey(String name, DataType dataType, Cardinality cardinality) {
            SchemaManager schema = this.graph.graph().schema();
            PropertyKey propertyKey = (PropertyKey)schema.propertyKey(name).dataType(dataType).cardinality(cardinality).build();
            this.graph.schemaTransaction().addPropertyKey(propertyKey);
            return name;
        }

        private IndexLabel createIndexLabel(VertexLabel label, String field) {
            SchemaManager schema = this.graph.graph().schema();
            String name = Graph.Hidden.hide((String)("server-index-by-" + field));
            IndexLabel indexLabel = (IndexLabel)schema.indexLabel(name).on(HugeType.VERTEX_LABEL, SERVER).by(field).build();
            this.graph.schemaTransaction().addIndexLabel(label, indexLabel);
            return indexLabel;
        }

        private IndexLabel indexLabel(String field) {
            String name = Graph.Hidden.hide((String)("server-index-by-" + field));
            return this.graph.graph().indexLabel(name);
        }
    }

    public static final class P {
        public static final String SERVER = Graph.Hidden.hide((String)"server");
        public static final String ID = T.id.getAccessor();
        public static final String LABEL = T.label.getAccessor();
        public static final String NAME = "~server_name";
        public static final String ROLE = "~server_role";
        public static final String LOAD = "~server_load";
        public static final String MAX_LOAD = "~server_max_load";
        public static final String UPDATE_TIME = "~server_update_time";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"server_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

