/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.dictionary.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apdplat.word.dictionary.Dictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AhoCorasickDoubleArrayTrie<V>
implements Serializable,
Dictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(AhoCorasickDoubleArrayTrie.class);
    private AtomicInteger maxLength = new AtomicInteger();
    protected int[] check;
    protected int[] base;
    protected int[] fail;
    protected int[][] output;
    protected V[] v;
    protected int[] l;
    protected int size;

    public AhoCorasickDoubleArrayTrie() {
        LOGGER.info("\u521d\u59cb\u5316\u8bcd\u5178\uff1a" + this.getClass().getName());
    }

    public List<Hit<V>> parseText(String string) {
        return this.parseText(string, 0, string.length());
    }

    public List<Hit<V>> parseText(String string, int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        LinkedList<Hit<V>> linkedList = new LinkedList<Hit<V>>();
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            n4 = this.getState(n4, string.charAt(i));
            this.storeEmits(n3, n4, linkedList);
            ++n3;
        }
        return linkedList;
    }

    public void parseText(String string, IHit<V> iHit) {
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int[] nArray = this.output[n2 = this.getState(n2, string.charAt(i))];
            if (nArray != null) {
                for (int n3 : nArray) {
                    iHit.hit(n - this.l[n3], n, this.v[n3]);
                }
            }
            ++n;
        }
    }

    public void parseText(char[] cArray, IHit<V> iHit) {
        int n = 1;
        int n2 = 0;
        for (char c : cArray) {
            int[] nArray = this.output[n2 = this.getState(n2, c)];
            if (nArray != null) {
                for (int n3 : nArray) {
                    iHit.hit(n - this.l[n3], n, this.v[n3]);
                }
            }
            ++n;
        }
    }

    public void parseText(char[] cArray, IHitFull<V> iHitFull) {
        int n = 1;
        int n2 = 0;
        for (char c : cArray) {
            int[] nArray = this.output[n2 = this.getState(n2, c)];
            if (nArray != null) {
                for (int n3 : nArray) {
                    iHitFull.hit(n - this.l[n3], n, this.v[n3], n3);
                }
            }
            ++n;
        }
    }

    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.base);
        objectOutputStream.writeObject(this.check);
        objectOutputStream.writeObject(this.fail);
        objectOutputStream.writeObject(this.output);
        objectOutputStream.writeObject(this.l);
        objectOutputStream.writeObject(this.v);
    }

    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.base = (int[])objectInputStream.readObject();
        this.check = (int[])objectInputStream.readObject();
        this.fail = (int[])objectInputStream.readObject();
        this.output = (int[][])objectInputStream.readObject();
        this.l = (int[])objectInputStream.readObject();
        this.v = (Object[])objectInputStream.readObject();
    }

    public V get(String string) {
        int n = this.exactMatchSearch(string);
        if (n >= 0) {
            return this.v[n];
        }
        return null;
    }

    public V get(int n) {
        return this.v[n];
    }

    @Override
    public int getMaxLength() {
        return this.maxLength.get();
    }

    @Override
    public boolean contains(String string, int n, int n2) {
        if (this.base == null) {
            return false;
        }
        List<Hit<V>> list = this.parseText(string, n, n2);
        for (Hit<V> hit : list) {
            if (hit.end - hit.begin != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String string) {
        return this.contains(string, 0, string.length());
    }

    @Override
    public void addAll(List<String> list) {
        if (this.check != null) {
            throw new RuntimeException("addAll method can just be used once after clear method!");
        }
        HashMap hashMap = new HashMap();
        list.stream().map(string -> string.trim()).filter(string -> {
            int n = string.length();
            if (n > this.maxLength.get()) {
                this.maxLength.set(n);
            }
            return n > 0;
        }).forEach(string -> hashMap.put(string, string));
        this.build(hashMap);
    }

    @Override
    public void add(String string) {
        throw new RuntimeException("not yet support, please use addAll method!");
    }

    @Override
    public void removeAll(List<String> list) {
        throw new RuntimeException("not yet support menthod!");
    }

    @Override
    public void remove(String string) {
        throw new RuntimeException("not yet support menthod!");
    }

    @Override
    public void clear() {
        this.check = null;
        this.base = null;
        this.fail = null;
        this.output = null;
        this.v = null;
        this.l = null;
        this.size = 0;
        this.maxLength.set(0);
    }

    private int getState(int n, char c) {
        int n2 = this.transitionWithRoot(n, c);
        while (n2 == -1) {
            n = this.fail[n];
            n2 = this.transitionWithRoot(n, c);
        }
        return n2;
    }

    private void storeEmits(int n, int n2, List<Hit<V>> list) {
        int[] nArray = this.output[n2];
        if (nArray != null) {
            for (int n3 : nArray) {
                list.add(new Hit<V>(n - this.l[n3], n, this.v[n3]));
            }
        }
    }

    protected int transition(int n, char c) {
        int n2 = n;
        int n3 = n2 + c + 1;
        if (n2 != this.check[n3]) {
            return -1;
        }
        n2 = this.base[n3];
        n3 = n2;
        return n3;
    }

    protected int transitionWithRoot(int n, char c) {
        int n2 = this.base[n];
        int n3 = n2 + c + 1;
        if (n2 != this.check[n3]) {
            if (n == 0) {
                return 0;
            }
            return -1;
        }
        return n3;
    }

    public void build(Map<String, V> map) {
        new Builder().build(map);
    }

    public int exactMatchSearch(String string) {
        return this.exactMatchSearch(string, 0, 0, 0);
    }

    private int exactMatchSearch(String string, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 <= 0) {
            n2 = string.length();
        }
        if (n3 <= 0) {
            n3 = 0;
        }
        int n6 = -1;
        char[] cArray = string.toCharArray();
        int n7 = this.base[n3];
        for (n5 = n; n5 < n2; ++n5) {
            n4 = n7 + cArray[n5] + 1;
            if (n7 != this.check[n4]) {
                return n6;
            }
            n7 = this.base[n4];
        }
        n4 = n7;
        n5 = this.base[n4];
        if (n7 == this.check[n4] && n5 < 0) {
            n6 = -n5 - 1;
        }
        return n6;
    }

    private int exactMatchSearch(char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = -1;
        int n7 = this.base[n3];
        for (n5 = n; n5 < n2; ++n5) {
            n4 = n7 + cArray[n5] + 1;
            if (n7 != this.check[n4]) {
                return n6;
            }
            n7 = this.base[n4];
        }
        n4 = n7;
        n5 = this.base[n4];
        if (n7 == this.check[n4] && n5 < 0) {
            n6 = -n5 - 1;
        }
        return n6;
    }

    public int size() {
        return this.v.length;
    }

    public static void main(String[] stringArray) {
        AhoCorasickDoubleArrayTrie ahoCorasickDoubleArrayTrie = new AhoCorasickDoubleArrayTrie();
        List<String> list = Arrays.asList("\u6768\u5c1a\u5ddd", "\u7ae0\u5b50\u6021", "\u5218\u4ea6\u83f2", "\u5218", "\u5218\u8bd7\u8bd7", "\u5de9\u4fd0", "\u4e2d\u56fd", "\u4e3b\u6f14");
        ahoCorasickDoubleArrayTrie.addAll(list);
        System.out.println("\u589e\u52a0\u6570\u636e\uff1a" + list);
        System.out.println("\u6700\u5927\u8bcd\u957f\uff1a" + ahoCorasickDoubleArrayTrie.getMaxLength());
        System.out.println("\u67e5\u627e \u6768\u5c1a\u5ddd\u7684\u68a6\u4e2d\u60c5\u4eba\u662f\u5218\u4ea6\u83f2\uff0c\u66fe\u7ecf\u4e5f\u7231\u8fc7\u7ae0\u5b50\u6021\uff0c\u5218\u8bd7\u8bd7\u4ee5\u53ca\u5de9\u4fd0\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u6768\u5c1a\u5ddd\u7684\u68a6\u4e2d\u60c5\u4eba\u662f\u5218\u4ea6\u83f2\uff0c\u66fe\u7ecf\u4e5f\u7231\u8fc7\u7ae0\u5b50\u6021\uff0c\u5218\u8bd7\u8bd7\u4ee5\u53ca\u5de9\u4fd0"));
        System.out.println("\u67e5\u627e \u6768\u5c1a\u5ddd\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u6768\u5c1a\u5ddd"));
        System.out.println("\u67e5\u627e \u7ae0\u5b50\u6021\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u7ae0\u5b50\u6021"));
        System.out.println("\u67e5\u627e \u5218\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u5218"));
        System.out.println("\u67e5\u627e \u5218\u4ea6\u83f2\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u5218\u4ea6\u83f2"));
        System.out.println("\u67e5\u627e \u5218\u8bd7\u8bd7\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u5218\u8bd7\u8bd7"));
        System.out.println("\u67e5\u627e \u5de9\u4fd0\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u5de9\u4fd0"));
        System.out.println("\u67e5\u627e \u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14 3 2\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14", 3, 2));
        System.out.println("\u67e5\u627e \u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14 0 2\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14", 0, 2));
        System.out.println("\u67e5\u627e \u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14 10 2\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14", 10, 2));
        System.out.println("\u67e5\u627e \u590d\u4ec7\u8005\u8054\u76df2\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u590d\u4ec7\u8005\u8054\u76df2"));
        System.out.println("\u67e5\u627e \u767d\u638c\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u767d\u638c"));
        System.out.println("\u67e5\u627e \u7ea2\u638c\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u7ea2\u638c"));
        ahoCorasickDoubleArrayTrie.clear();
        System.out.println("\u6e05\u9664\u6240\u6709\u6570\u636e");
        System.out.println("\u67e5\u627e \u6768\u5c1a\u5ddd\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u6768\u5c1a\u5ddd"));
        System.out.println("\u67e5\u627e \u7ae0\u5b50\u6021\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u7ae0\u5b50\u6021"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u767d\u638c");
        arrayList.add("\u7ea2\u638c");
        arrayList.add("\u590d\u4ec7\u8005\u8054\u76df2");
        arrayList.addAll(list);
        ahoCorasickDoubleArrayTrie.addAll(arrayList);
        System.out.println("\u589e\u52a0\u6570\u636e\uff1a" + arrayList);
        System.out.println("\u67e5\u627e \u6768\u5c1a\u5ddd\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u6768\u5c1a\u5ddd"));
        System.out.println("\u67e5\u627e \u7ae0\u5b50\u6021\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u7ae0\u5b50\u6021"));
        System.out.println("\u6700\u5927\u8bcd\u957f\uff1a" + ahoCorasickDoubleArrayTrie.getMaxLength());
        System.out.println("\u67e5\u627e \u590d\u4ec7\u8005\u8054\u76df2\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u590d\u4ec7\u8005\u8054\u76df2"));
        System.out.println("\u67e5\u627e \u767d\u638c\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u767d\u638c"));
        System.out.println("\u67e5\u627e \u7ea2\u638c\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u7ea2\u638c"));
        System.out.println("\u67e5\u627e \u5218\u4ea6\u83f2\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u5218\u4ea6\u83f2"));
        System.out.println("\u67e5\u627e \u5218\u8bd7\u8bd7\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u5218\u8bd7\u8bd7"));
        System.out.println("\u67e5\u627e \u5de9\u4fd0\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u5de9\u4fd0"));
        System.out.println("\u67e5\u627e \u91d1\u94b1\u6811\uff1a" + ahoCorasickDoubleArrayTrie.contains("\u91d1\u94b1\u6811"));
    }

    private static class State {
        protected final int depth;
        private State failure = null;
        private Set<Integer> emits = null;
        private Map<Character, State> success = new TreeMap<Character, State>();
        private int index;

        public State() {
            this(0);
        }

        public State(int n) {
            this.depth = n;
        }

        public int getDepth() {
            return this.depth;
        }

        public void addEmit(int n) {
            if (this.emits == null) {
                this.emits = new TreeSet(Collections.reverseOrder());
            }
            this.emits.add(n);
        }

        public Integer getLargestValueId() {
            if (this.emits == null || this.emits.size() == 0) {
                return null;
            }
            return this.emits.iterator().next();
        }

        public void addEmit(Collection<Integer> collection) {
            for (int n : collection) {
                this.addEmit(n);
            }
        }

        public Collection<Integer> emit() {
            return this.emits == null ? Collections.emptyList() : this.emits;
        }

        public boolean isAcceptable() {
            return this.depth > 0 && this.emits != null;
        }

        public State failure() {
            return this.failure;
        }

        public void setFailure(State state, int[] nArray) {
            this.failure = state;
            nArray[this.index] = state.index;
        }

        private State nextState(Character c, boolean bl) {
            State state = this.success.get(c);
            if (!bl && state == null && this.depth == 0) {
                state = this;
            }
            return state;
        }

        public State nextState(Character c) {
            return this.nextState(c, false);
        }

        public State nextStateIgnoreRootState(Character c) {
            return this.nextState(c, true);
        }

        public State addState(Character c) {
            State state = this.nextStateIgnoreRootState(c);
            if (state == null) {
                state = new State(this.depth + 1);
                this.success.put(c, state);
            }
            return state;
        }

        public Collection<State> getStates() {
            return this.success.values();
        }

        public Collection<Character> getTransitions() {
            return this.success.keySet();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("State{");
            stringBuilder.append("depth=").append(this.depth);
            stringBuilder.append(", ID=").append(this.index);
            stringBuilder.append(", emits=").append(this.emits);
            stringBuilder.append(", success=").append(this.success.keySet());
            stringBuilder.append(", failureID=").append(this.failure == null ? "-1" : Integer.valueOf(this.failure.index));
            stringBuilder.append(", failure=").append(this.failure);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public Map<Character, State> getSuccess() {
            return this.success;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }
    }

    private class Builder {
        private State rootState = new State();
        private boolean[] used;
        private int allocSize;
        private int progress;
        private int nextCheckPos;
        private int keySize;

        private Builder() {
        }

        public void build(Map<String, V> map) {
            AhoCorasickDoubleArrayTrie.this.v = map.values().toArray();
            AhoCorasickDoubleArrayTrie.this.l = new int[AhoCorasickDoubleArrayTrie.this.v.length];
            Set<String> set = map.keySet();
            this.addAllKeyword(set);
            this.buildDoubleArrayTrie(set.size());
            this.used = null;
            this.constructFailureStates();
            this.rootState = null;
            this.loseWeight();
        }

        private int fetch(State state, List<Map.Entry<Integer, State>> list) {
            if (state.isAcceptable()) {
                State state2 = new State(-(state.getDepth() + 1));
                state2.addEmit(state.getLargestValueId());
                list.add(new AbstractMap.SimpleEntry<Integer, Object>(0, state2));
            }
            for (Map.Entry entry : state.getSuccess().entrySet()) {
                list.add(new AbstractMap.SimpleEntry(((Character)entry.getKey()).charValue() + '\u0001', entry.getValue()));
            }
            return list.size();
        }

        private void addKeyword(String string, int n) {
            State state = this.rootState;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                Character c = Character.valueOf(cArray[i]);
                state = state.addState(c);
            }
            state.addEmit(n);
            AhoCorasickDoubleArrayTrie.this.l[n] = string.length();
        }

        private void addAllKeyword(Collection<String> collection) {
            int n = 0;
            for (String string : collection) {
                this.addKeyword(string, n++);
            }
        }

        private void constructFailureStates() {
            AhoCorasickDoubleArrayTrie.this.fail = new int[AhoCorasickDoubleArrayTrie.this.size + 1];
            AhoCorasickDoubleArrayTrie.this.fail[1] = AhoCorasickDoubleArrayTrie.this.base[0];
            AhoCorasickDoubleArrayTrie.this.output = new int[AhoCorasickDoubleArrayTrie.this.size + 1][];
            LinkedBlockingDeque<State> linkedBlockingDeque = new LinkedBlockingDeque<State>();
            for (State object : this.rootState.getStates()) {
                object.setFailure(this.rootState, AhoCorasickDoubleArrayTrie.this.fail);
                linkedBlockingDeque.add(object);
                this.constructOutput(object);
            }
            while (!linkedBlockingDeque.isEmpty()) {
                State state = (State)linkedBlockingDeque.remove();
                for (Character c : state.getTransitions()) {
                    State state2 = state.nextState(c);
                    linkedBlockingDeque.add(state2);
                    State state3 = state.failure();
                    while (state3.nextState(c) == null) {
                        state3 = state3.failure();
                    }
                    State state4 = state3.nextState(c);
                    state2.setFailure(state4, AhoCorasickDoubleArrayTrie.this.fail);
                    state2.addEmit(state4.emit());
                    this.constructOutput(state2);
                }
            }
        }

        private void constructOutput(State state) {
            Collection<Integer> collection = state.emit();
            if (collection == null || collection.size() == 0) {
                return;
            }
            int[] nArray = new int[collection.size()];
            Iterator<Integer> iterator = collection.iterator();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = iterator.next();
            }
            AhoCorasickDoubleArrayTrie.this.output[state.getIndex()] = nArray;
        }

        private void buildDoubleArrayTrie(int n) {
            this.progress = 0;
            this.keySize = n;
            this.resize(0x200000);
            AhoCorasickDoubleArrayTrie.this.base[0] = 1;
            this.nextCheckPos = 0;
            State state = this.rootState;
            ArrayList<Map.Entry<Integer, State>> arrayList = new ArrayList<Map.Entry<Integer, State>>(state.getSuccess().entrySet().size());
            this.fetch(state, arrayList);
            this.insert(arrayList);
        }

        private int resize(int n) {
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            boolean[] blArray = new boolean[n];
            if (this.allocSize > 0) {
                System.arraycopy(AhoCorasickDoubleArrayTrie.this.base, 0, nArray, 0, this.allocSize);
                System.arraycopy(AhoCorasickDoubleArrayTrie.this.check, 0, nArray2, 0, this.allocSize);
                System.arraycopy(this.used, 0, blArray, 0, this.allocSize);
            }
            AhoCorasickDoubleArrayTrie.this.base = nArray;
            AhoCorasickDoubleArrayTrie.this.check = nArray2;
            this.used = blArray;
            this.allocSize = n;
            return this.allocSize;
        }

        private int insert(List<Map.Entry<Integer, State>> list) {
            int n = 0;
            int n2 = Math.max(list.get(0).getKey() + 1, this.nextCheckPos) - 1;
            int n3 = 0;
            boolean bl = false;
            if (this.allocSize <= n2) {
                this.resize(n2 + 1);
            }
            block0: while (true) {
                if (this.allocSize <= ++n2) {
                    this.resize(n2 + 1);
                }
                if (AhoCorasickDoubleArrayTrie.this.check[n2] != 0) {
                    ++n3;
                    continue;
                }
                if (!bl) {
                    this.nextCheckPos = n2;
                    bl = true;
                }
                if (this.allocSize <= (n = n2 - list.get(0).getKey()) + list.get(list.size() - 1).getKey()) {
                    double d = 1.05 > 1.0 * (double)this.keySize / (double)(this.progress + 1) ? 1.05 : 1.0 * (double)this.keySize / (double)(this.progress + 1);
                    this.resize((int)((double)this.allocSize * d));
                }
                if (this.used[n]) continue;
                for (int i = 1; i < list.size(); ++i) {
                    if (AhoCorasickDoubleArrayTrie.this.check[n + list.get(i).getKey()] == 0) continue;
                    continue block0;
                }
                break;
            }
            if (1.0 * (double)n3 / (double)(n2 - this.nextCheckPos + 1) >= 0.95) {
                this.nextCheckPos = n2;
            }
            this.used[n] = true;
            AhoCorasickDoubleArrayTrie.this.size = AhoCorasickDoubleArrayTrie.this.size > n + list.get(list.size() - 1).getKey() + 1 ? AhoCorasickDoubleArrayTrie.this.size : n + list.get(list.size() - 1).getKey() + 1;
            for (Map.Entry<Integer, State> entry : list) {
                AhoCorasickDoubleArrayTrie.this.check[n + entry.getKey().intValue()] = n;
            }
            for (Map.Entry<Integer, State> entry : list) {
                ArrayList<Map.Entry<Integer, State>> arrayList = new ArrayList<Map.Entry<Integer, State>>(entry.getValue().getSuccess().entrySet().size() + 1);
                if (this.fetch(entry.getValue(), arrayList) == 0) {
                    AhoCorasickDoubleArrayTrie.this.base[n + entry.getKey().intValue()] = -entry.getValue().getLargestValueId().intValue() - 1;
                    ++this.progress;
                } else {
                    int n4;
                    AhoCorasickDoubleArrayTrie.this.base[n + entry.getKey().intValue()] = n4 = this.insert(arrayList);
                }
                entry.getValue().setIndex(n + entry.getKey());
            }
            return n;
        }

        private void loseWeight() {
            int[] nArray = new int[AhoCorasickDoubleArrayTrie.this.size + 65535];
            System.arraycopy(AhoCorasickDoubleArrayTrie.this.base, 0, nArray, 0, AhoCorasickDoubleArrayTrie.this.size);
            AhoCorasickDoubleArrayTrie.this.base = nArray;
            int[] nArray2 = new int[AhoCorasickDoubleArrayTrie.this.size + 65535];
            System.arraycopy(AhoCorasickDoubleArrayTrie.this.check, 0, nArray2, 0, AhoCorasickDoubleArrayTrie.this.size);
            AhoCorasickDoubleArrayTrie.this.check = nArray2;
        }
    }

    public class Hit<V> {
        public final int begin;
        public final int end;
        public final V value;

        public Hit(int n, int n2, V v) {
            this.begin = n;
            this.end = n2;
            this.value = v;
        }

        public String toString() {
            return String.format("[%d:%d]=%s", this.begin, this.end, this.value);
        }
    }

    public static interface IHitFull<V> {
        public void hit(int var1, int var2, V var3, int var4);
    }

    public static interface IHit<V> {
        public void hit(int var1, int var2, V var3);
    }
}

