/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.elasticsearch;

import org.apache.lucene.analysis.Tokenizer;
import org.apdplat.word.lucene.ChineseWordTokenizer;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseWordTokenizerFactory
extends AbstractTokenizerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChineseWordTokenizerFactory.class);
    private final Segmentation segmentation;

    @Inject
    public ChineseWordTokenizerFactory(Index index, @IndexSettings Settings settings, @Assisted String string, @Assisted Settings settings2) {
        super(index, settings, string, settings2);
        String string2 = settings2.get("segAlgorithm");
        if (string2 != null) {
            LOGGER.info("tokenizer\u4f7f\u7528\u6307\u5b9a\u5206\u8bcd\u7b97\u6cd5\uff1a" + string2);
            this.segmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.valueOf(string2));
        } else {
            LOGGER.info("\u6ca1\u6709\u4e3aword tokenizer\u6307\u5b9asegAlgorithm\u53c2\u6570");
            LOGGER.info("tokenizer\u4f7f\u7528\u9ed8\u8ba4\u5206\u8bcd\u7b97\u6cd5\uff1a" + (Object)((Object)SegmentationAlgorithm.BidirectionalMaximumMatching));
            this.segmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching);
        }
    }

    public Tokenizer create() {
        return new ChineseWordTokenizer(this.segmentation);
    }
}

