/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.List;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class MinimumMatching
extends AbstractSegmentation {
    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.MinimumMatching;
    }

    @Override
    public List<Word> segImpl(String string) {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        int n = string.length();
        int n2 = 1;
        for (int i = 0; i < n; i += n2) {
            while (!this.getDictionary().contains(string, i, n2) && !RecognitionTool.recog(string, i, n2)) {
                if (n2 == this.getInterceptLength() || n2 == n - i) {
                    n2 = 1;
                    break;
                }
                ++n2;
            }
            this.addWord(arrayList, string, i, n2);
            n2 = 1;
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String string = "\u300a\u7ea2\u697c\u68a6\u300b\u7684\u4f5c\u8005\u662f\u66f9\u96ea\u82b9\u3002\u8bfe\u6587\u91cc\u6709\u4e00\u7bc7\u9c81\u8fc5\u7684\u300a\u4ece\u767e\u8349\u56ed\u5230\u4e09\u5473\u4e66\u5c4b\u300b\u3002\u4ed6\u7684\u6587\u7ae0\u5728\u300a\u4eba\u6c11\u65e5\u62a5\u300b\u4e0a\u53d1\u8868\u4e86\u3002\u684c\u4e0a\u653e\u7740\u4e00\u672c\u300a\u4e2d\u56fd\u8bed\u6587\u300b\u3002\u300a\u3008\u4e2d\u56fd\u5de5\u4eba\u3009\u53d1\u520a\u8bcd\u300b\u53d1\u8868\u4e8e1940\u5e742\u67087\u65e5\u3002\u6768\u5c1a\u5ddd\u662fAPDPlat\u5e94\u7528\u7ea7\u4ea7\u54c1\u5f00\u53d1\u5e73\u53f0\u7684\u4f5c\u8005";
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        MinimumMatching minimumMatching = new MinimumMatching();
        System.out.println(minimumMatching.seg(string).toString());
    }
}

