/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTrie<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericTrie.class);
    private static final int INDEX_LENGTH = 12000;
    private final TrieNode<V>[] ROOT_NODES_INDEX = new TrieNode[12000];

    public void clear() {
        for (int i = 0; i < 12000; ++i) {
            this.ROOT_NODES_INDEX[i] = null;
        }
    }

    public void showConflict() {
        int n = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (TrieNode<V> trieNode : this.ROOT_NODES_INDEX) {
            if (trieNode == null) {
                ++n;
                continue;
            }
            int n2 = 0;
            while ((trieNode = trieNode.getSibling()) != null) {
                ++n2;
            }
            if (n2 <= 0) continue;
            Integer n3 = (Integer)hashMap.get(n2);
            if (n3 == null) {
                n3 = 1;
            } else {
                Integer n4 = n3;
                Integer n5 = n3 = Integer.valueOf(n3 + 1);
            }
            hashMap.put(n2, n3);
        }
        int n6 = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n7 = (Integer)iterator.next();
            int n8 = (Integer)hashMap.get(n7);
            n6 += n7 * n8;
            LOGGER.info("\u51b2\u7a81\u6b21\u6570\u4e3a\uff1a" + n7 + " \u7684\u5143\u7d20\u4e2a\u6570\uff1a" + n8);
        }
        LOGGER.info("\u51b2\u7a81\u6b21\u6570\uff1a" + n6);
        LOGGER.info("\u603b\u69fd\u6570\uff1a12000");
        LOGGER.info("\u7528\u69fd\u6570\uff1a" + (12000 - n));
        LOGGER.info("\u4f7f\u7528\u7387\uff1a" + (float)(12000 - n) / 12000.0f * 100.0f + "%");
        LOGGER.info("\u5269\u69fd\u6570\uff1a" + n);
    }

    private TrieNode<V> getRootNodeIfNotExistThenCreate(char c) {
        TrieNode<V> trieNode = this.getRootNode(c);
        if (trieNode == null) {
            trieNode = new TrieNode(c);
            this.addRootNode(trieNode);
        }
        return trieNode;
    }

    private void addRootNode(TrieNode<V> trieNode) {
        int n = trieNode.getCharacter() % 12000;
        TrieNode<V> trieNode2 = this.ROOT_NODES_INDEX[n];
        if (trieNode2 != null) {
            trieNode.setSibling(trieNode2);
        }
        this.ROOT_NODES_INDEX[n] = trieNode;
    }

    private TrieNode<V> getRootNode(char c) {
        TrieNode<V> trieNode;
        int n = c % 12000;
        for (trieNode = this.ROOT_NODES_INDEX[n]; trieNode != null && c != trieNode.getCharacter(); trieNode = trieNode.getSibling()) {
        }
        return trieNode;
    }

    public V get(String string) {
        return this.get(string, 0, string.length());
    }

    public V get(String string, int n, int n2) {
        if (n < 0 || n2 < 1) {
            return null;
        }
        if (string == null || string.length() < n2) {
            return null;
        }
        TrieNode<V> trieNode = this.getRootNode(string.charAt(n));
        if (trieNode == null) {
            return null;
        }
        for (int i = 1; i < n2; ++i) {
            char c = string.charAt(i + n);
            TrieNode<V> trieNode2 = trieNode.getChild(c);
            if (trieNode2 == null) {
                return null;
            }
            trieNode = trieNode2;
        }
        if (trieNode.isTerminal()) {
            return trieNode.getValue();
        }
        return null;
    }

    public void remove(String string) {
        TrieNode<V> trieNode;
        if (string == null || string.isEmpty()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u79fb\u9664\u8bcd\u6027\uff1a" + string);
        }
        if ((trieNode = this.getRootNode(string.charAt(0))) == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bcd\u6027\u4e0d\u5b58\u5728\uff1a" + string);
            }
            return;
        }
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            TrieNode<V> trieNode2 = trieNode.getChild(c);
            if (trieNode2 == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u8bcd\u6027\u4e0d\u5b58\u5728\uff1a" + string);
                }
                return;
            }
            trieNode = trieNode2;
        }
        if (trieNode.isTerminal()) {
            trieNode.setTerminal(false);
            trieNode.setValue(null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6210\u529f\u79fb\u9664\u8bcd\u6027\uff1a" + string);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bcd\u6027\u4e0d\u5b58\u5728\uff1a" + string);
        }
    }

    public void put(String string, V v) {
        int n = (string = string.trim()).length();
        if (n < 1) {
            return;
        }
        TrieNode<V> trieNode = this.getRootNodeIfNotExistThenCreate(string.charAt(0));
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            TrieNode<V> trieNode2 = trieNode.getChildIfNotExistThenCreate(c);
            trieNode = trieNode2;
        }
        trieNode.setTerminal(true);
        trieNode.setValue(v);
    }

    public void show(char c) {
        this.show(this.getRootNode(c), "");
    }

    public void show() {
        for (TrieNode<V> trieNode : this.ROOT_NODES_INDEX) {
            if (trieNode == null) continue;
            this.show(trieNode, "");
        }
    }

    private void show(TrieNode<V> trieNode, String string) {
        if (trieNode.isTerminal()) {
            LOGGER.info(string + trieNode.getCharacter() + "=" + trieNode.getValue() + "(T)");
        } else {
            LOGGER.info(string + trieNode.getCharacter());
        }
        for (TrieNode<V> trieNode2 : trieNode.getChildren()) {
            this.show(trieNode2, string + "\t");
        }
    }

    public static void main(String[] stringArray) {
        GenericTrie<String> genericTrie = new GenericTrie<String>();
        genericTrie.put("\u6768\u5c1a\u5ddd", "nr");
        genericTrie.put("\u6768\u5c1a\u559c", "nr");
        genericTrie.put("\u4eba", "n");
        genericTrie.put("\u5199\u4ee3\u7801", "v");
        genericTrie.showConflict();
        genericTrie.show();
        LOGGER.info("\u6768\u5c1a\u5ddd\uff1a" + (String)genericTrie.get("\u6768\u5c1a\u5ddd"));
        LOGGER.info("\u6768\u5c1a\u559c\uff1a" + (String)genericTrie.get("\u6768\u5c1a\u559c"));
        LOGGER.info("\u4eba\uff1a" + (String)genericTrie.get("\u4eba"));
        LOGGER.info("\u5199\u4ee3\u7801\uff1a" + (String)genericTrie.get("\u5199\u4ee3\u7801"));
        GenericTrie<Integer> genericTrie2 = new GenericTrie<Integer>();
        genericTrie2.put("\u6768\u5c1a\u5ddd", 100);
        genericTrie2.put("\u6768\u5c1a\u559c", 90);
        genericTrie2.put("\u4eba", 10);
        genericTrie2.put("\u5199\u4ee3\u7801", 80);
        genericTrie2.showConflict();
        genericTrie2.show();
        LOGGER.info("\u6768\u5c1a\u5ddd\uff1a" + genericTrie2.get("\u6768\u5c1a\u5ddd"));
        LOGGER.info("\u6768\u5c1a\u559c\uff1a" + genericTrie2.get("\u6768\u5c1a\u559c"));
        LOGGER.info("\u4eba\uff1a" + genericTrie2.get("\u4eba"));
        LOGGER.info("\u5199\u4ee3\u7801\uff1a" + genericTrie2.get("\u5199\u4ee3\u7801"));
    }

    private static class TrieNode<V>
    implements Comparable {
        private char character;
        private V value;
        private boolean terminal;
        private TrieNode<V> sibling;
        private TrieNode<V>[] children = new TrieNode[0];

        public TrieNode(char c) {
            this.character = c;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public void setTerminal(boolean bl) {
            this.terminal = bl;
        }

        public char getCharacter() {
            return this.character;
        }

        public void setCharacter(char c) {
            this.character = c;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V v) {
            this.value = v;
        }

        public TrieNode<V> getSibling() {
            return this.sibling;
        }

        public void setSibling(TrieNode<V> trieNode) {
            this.sibling = trieNode;
        }

        public Collection<TrieNode<V>> getChildren() {
            return Arrays.asList(this.children);
        }

        public TrieNode<V> getChild(char c) {
            int n = Arrays.binarySearch(this.children, Character.valueOf(c));
            if (n >= 0) {
                return this.children[n];
            }
            return null;
        }

        public TrieNode<V> getChildIfNotExistThenCreate(char c) {
            TrieNode<V> trieNode = this.getChild(c);
            if (trieNode == null) {
                trieNode = new TrieNode<V>(c);
                this.addChild(trieNode);
            }
            return trieNode;
        }

        public void addChild(TrieNode<V> trieNode) {
            this.children = this.insert(this.children, trieNode);
        }

        private TrieNode<V>[] insert(TrieNode<V>[] trieNodeArray, TrieNode<V> trieNode) {
            int n = trieNodeArray.length;
            if (n == 0) {
                trieNodeArray = new TrieNode[]{trieNode};
                return trieNodeArray;
            }
            TrieNode[] trieNodeArray2 = new TrieNode[n + 1];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (trieNode.getCharacter() <= trieNodeArray[i].getCharacter()) {
                    trieNodeArray2[i] = trieNode;
                    System.arraycopy(trieNodeArray, i, trieNodeArray2, i + 1, n - i);
                    bl = true;
                    break;
                }
                trieNodeArray2[i] = trieNodeArray[i];
            }
            if (!bl) {
                trieNodeArray2[n] = trieNode;
            }
            return trieNodeArray2;
        }

        public int compareTo(Object object) {
            return this.getCharacter() - ((Character)object).charValue();
        }
    }
}

