/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rest;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;
import org.apache.hugegraph.rest.RestHeaders;
import org.apache.hugegraph.rest.SerializeException;

public class RestResult {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final int status;
    private final RestHeaders headers;
    private final String content;

    public RestResult(Response response) {
        this(response.code(), RestResult.getResponseContent(response), RestHeaders.convertToRestHeaders(response.headers()));
    }

    public RestResult(int status, String content, RestHeaders headers) {
        this.status = status;
        this.headers = headers;
        this.content = content;
    }

    private static String getResponseContent(Response response) {
        return response.body().string();
    }

    public static void registerModule(Module module) {
        MAPPER.registerModule(module);
    }

    public int status() {
        return this.status;
    }

    public RestHeaders headers() {
        return this.headers;
    }

    public String content() {
        return this.content;
    }

    public <T> T readObject(Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(this.content, clazz);
        }
        catch (Exception e) {
            throw new SerializeException("Failed to deserialize: %s", (Throwable)e, this.content);
        }
    }

    public <T> List<T> readList(String key, Class<T> clazz) {
        try {
            JsonNode root = MAPPER.readTree(this.content);
            JsonNode element = root.get(key);
            if (element == null) {
                throw new SerializeException("Can't find value of the key: %s in json.", key);
            }
            JavaType type = MAPPER.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, new Class[]{clazz});
            return (List)MAPPER.convertValue((Object)element, type);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize %s", (Throwable)e, this.content);
        }
    }

    public <T> List<T> readList(Class<T> clazz) {
        JavaType type = MAPPER.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, new Class[]{clazz});
        try {
            return (List)MAPPER.readValue(this.content, type);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize %s", (Throwable)e, this.content);
        }
    }

    public String toString() {
        return String.format("{status=%s, headers=%s, content=%s}", this.status, this.headers, this.content);
    }

    static {
        MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }
}

