/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.license;

import com.google.gson.Gson;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.license.MachineInfo;
import org.apache.hugegraph.pd.common.PDRuntimeException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.license.ExtraParam;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class LicenseVerifierService {
    private static final Logger log = LoggerFactory.getLogger(LicenseVerifierService.class);
    private PDConfig pdConfig;
    private final MachineInfo machineInfo;

    public LicenseVerifierService(PDConfig pdConfig) {
        this.pdConfig = pdConfig;
        this.machineInfo = new MachineInfo();
    }

    @Deprecated
    public void init() {
    }

    public synchronized void install(String md5) {
    }

    @Deprecated
    public HashMap getContext() throws Exception {
        return new HashMap();
    }

    @Deprecated
    public void verify(int cores, int nodeCount) {
    }

    public boolean isLeader() {
        return RaftEngine.getInstance().isLeader();
    }

    public String getIpAndMac() {
        String host;
        List actualIps = this.machineInfo.getIpAddress();
        String licenseHost = host = this.pdConfig.getHost();
        if (!actualIps.contains(host)) {
            licenseHost = (String)actualIps.get(0);
        }
        try {
            String mac = this.machineInfo.getMacByInetAddress(InetAddress.getByName(licenseHost));
            HashMap<String, String> ipAndMac = new HashMap<String, String>();
            ipAndMac.put("ip", licenseHost);
            ipAndMac.put("mac", mac);
            String json = new Gson().toJson(ipAndMac);
            String encode = Base64Utils.encodeToString((byte[])json.getBytes(Charset.defaultCharset()));
            return encode;
        }
        catch (Exception e) {
            throw new PDRuntimeException(107, String.format("Failed to get ip and mac for %s", e.getMessage()));
        }
    }

    private void checkIpAndMac(ExtraParam param) {
        String expectIp = param.ip();
        boolean matched = false;
        List actualIps = null;
        if (StringUtils.isEmpty((CharSequence)expectIp)) {
            matched = true;
        } else {
            actualIps = this.machineInfo.getIpAddress();
            for (String actualIp : actualIps) {
                if (!actualIp.equalsIgnoreCase(expectIp)) continue;
                matched = true;
                break;
            }
        }
        if (!matched) {
            throw new PDRuntimeException(108, String.format("The server's ip '%s' doesn't match the authorized '%s'", actualIps, expectIp));
        }
        String expectMac = param.mac();
        if (StringUtils.isEmpty((CharSequence)expectMac)) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)expectIp)) {
            String actualMac;
            try {
                actualMac = this.machineInfo.getMacByInetAddress(InetAddress.getByName(expectIp));
            }
            catch (UnknownHostException e) {
                throw new PDRuntimeException(108, String.format("Failed to get mac address for ip '%s'", expectIp));
            }
            String expectFormatMac = expectMac.replaceAll(":", "-");
            String actualFormatMac = actualMac.replaceAll(":", "-");
            if (!actualFormatMac.equalsIgnoreCase(expectFormatMac)) {
                throw new PDRuntimeException(108, String.format("The server's mac '%s' doesn't match the authorized '%s'", actualMac, expectMac));
            }
        } else {
            String expectFormatMac = expectMac.replaceAll(":", "-");
            List actualMacs = this.machineInfo.getMacAddress();
            matched = false;
            for (String actualMac : actualMacs) {
                String actualFormatMac = actualMac.replaceAll(":", "-");
                if (!actualFormatMac.equalsIgnoreCase(expectFormatMac)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                throw new PDRuntimeException(108, String.format("The server's macs %s don't match the authorized '%s'", actualMacs, expectMac));
            }
        }
    }
}

