/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SDConfig {
    private static final String LABEL_METRICS_PATH = "__metrics_path__";
    private static final String LABEL_SCHEME = "__scheme__";
    private static final String LABEL_JOB_NAME = "job";
    private static final String LABEL_CLUSTER = "cluster";
    private Set<String> targets = new HashSet();
    private Map<String, String> labels = new HashMap();

    private SDConfig() {
    }

    public static SDConfig of() {
        return new SDConfig();
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public SDConfig setTargets(Set<String> targets) {
        if (targets != null) {
            this.targets.clear();
            this.targets.addAll(targets);
        }
        return this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public SDConfig addTarget(String target) {
        if (target == null) {
            return this;
        }
        this.targets.add(target);
        return this;
    }

    public SDConfig setMetricsPath(String path) {
        return this.addLabel(LABEL_METRICS_PATH, path);
    }

    public SDConfig setScheme(String scheme) {
        return this.addLabel(LABEL_SCHEME, scheme);
    }

    public SDConfig setClusterId(String clusterId) {
        return this.addLabel(LABEL_CLUSTER, clusterId);
    }

    public SDConfig addLabel(String label, String value) {
        if (label == null || value == null) {
            return this;
        }
        this.labels.put(label, value);
        return this;
    }

    public String toString() {
        return "SDConfig{targets=" + String.valueOf(this.targets) + ", labels=" + String.valueOf(this.labels) + "}";
    }
}

