/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.util.VersionUtil;

public class API {
    public static final String VERSION = VersionUtil.getVersionFromProperties();
    public static final String PD = "PD";
    public static final String STORE = "STORE";
    public static String STATUS_KEY = "status";
    public static String ERROR_KEY = "error";
    public static String QUOTATION = "\"";
    public static String COMMA = ",";
    public static String COLON = ": ";

    public <T extends MessageOrBuilder> String toJSON(List<T> values, String key) {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append(QUOTATION).append(STATUS_KEY).append(QUOTATION).append(COLON).append("0").append(COMMA).append(QUOTATION).append(key).append(QUOTATION).append(COLON).append("[ ");
        if (values != null) {
            values.forEach(s -> {
                try {
                    builder.append(JsonFormat.printer().print(s));
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                }
                builder.append(",");
            });
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]}");
        return builder.toString();
    }

    public String toJSON(MessageOrBuilder value, String key) {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append(QUOTATION).append(STATUS_KEY).append(QUOTATION).append(COLON).append("0").append(COMMA).append(QUOTATION).append(key).append(QUOTATION).append(COLON);
        try {
            if (value != null) {
                builder.append(JsonFormat.printer().print(value));
            } else {
                builder.append("{}");
            }
            builder.append("}");
            return builder.toString();
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return this.toJSON((Throwable)e);
        }
    }

    public <T extends MessageOrBuilder> String toJSON(Map<String, List<T>> values) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (Map.Entry<String, List<T>> entry : values.entrySet()) {
            String entryKey = entry.getKey();
            List<MessageOrBuilder> entryValue = entry.getValue();
            builder.append(QUOTATION).append(entryKey).append(QUOTATION).append(COLON).append("[");
            if (entryValue != null && !entryValue.isEmpty()) {
                entryValue.forEach(s -> {
                    try {
                        if (s == null) {
                            builder.append("null");
                        } else {
                            builder.append(JsonFormat.printer().print(s));
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        e.printStackTrace();
                    }
                    builder.append(",");
                });
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append("]").append(COMMA);
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        return builder.toString();
    }

    public String toJSON(PDException exception) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(STATUS_KEY, exception.getErrorCode());
        m.put(ERROR_KEY, exception.getMessage() == null ? "" : exception.getMessage());
        return this.toJSON(m);
    }

    public String toJSON(Throwable exception) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(STATUS_KEY, -1);
        m.put(ERROR_KEY, exception == null || exception.getMessage() == null ? "" : exception.getMessage());
        return this.toJSON(m);
    }

    public String toJSON(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Map<String, Object> okMap(String k, Object v) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATUS_KEY, 0);
        map.put(k, v);
        return map;
    }

    public <T extends MessageOrBuilder> String toJSON(List<T> values, JsonFormat.TypeRegistry registry) {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append(QUOTATION).append(STATUS_KEY).append(QUOTATION).append(COLON).append("0").append(COMMA).append(QUOTATION).append("log").append(QUOTATION).append(COLON).append("[ ");
        JsonFormat.Printer printer = JsonFormat.printer().usingTypeRegistry(registry);
        if (values != null) {
            values.forEach(s -> {
                try {
                    builder.append(printer.print(s));
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                }
                builder.append(",");
            });
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]}");
        return builder.toString();
    }
}

