/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.model.PeerRestRequest;
import org.apache.hugegraph.pd.model.RestApiResponse;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.rest.MemberAPI;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class MemberAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(MemberAPI.class);
    @Autowired
    PDService pdService;

    @GetMapping(value={"/members"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getMembers() throws InterruptedException, ExecutionException {
        String leaderGrpcAddress = RaftEngine.getInstance().getLeaderGrpcAddress();
        CallStreamObserverWrap response = new CallStreamObserverWrap();
        this.pdService.getMembersAndClusterState(Pdpb.GetMembersRequest.newBuilder().build(), (StreamObserver)response);
        ArrayList<Member> members = new ArrayList<Member>();
        Member leader = null;
        HashMap<String, Integer> stateCountMap = new HashMap<String, Integer>();
        Pdpb.MembersAndClusterState membersAndClusterState = (Pdpb.MembersAndClusterState)response.get().get(0);
        for (Metapb.Member member : membersAndClusterState.getMembersList()) {
            String stateKey = member.getState().name();
            stateCountMap.put(stateKey, stateCountMap.getOrDefault(stateKey, 0) + 1);
            Member member1 = new Member(this, member);
            if (leaderGrpcAddress != null && leaderGrpcAddress.equals(member.getGrpcUrl())) {
                leader = member1;
            }
            member1.role = member.getRole().name();
            members.add(member1);
        }
        String state = membersAndClusterState.getState().toString();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("state", state);
        resultMap.put("pdList", members);
        resultMap.put("pdLeader", leader);
        resultMap.put("numOfService", members.size());
        resultMap.put("numOfNormalService", stateCountMap.getOrDefault(Metapb.StoreState.Up.name(), 0));
        resultMap.put("stateCountMap", stateCountMap);
        return new RestApiResponse(resultMap, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
    }

    @PostMapping(value={"/members/change"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String changePeerList(@RequestBody PeerRestRequest body, HttpServletRequest request) {
        try {
            Pdpb.ChangePeerListRequest rpcRequest = Pdpb.ChangePeerListRequest.newBuilder().setPeerList(body.getPeerList()).build();
            CountDownLatch latch = new CountDownLatch(1);
            Pdpb.ResponseHeader[] responseHeader = new Pdpb.ResponseHeader[]{null};
            1 observer = new /* Unavailable Anonymous Inner Class!! */;
            this.pdService.changePeerList(rpcRequest, (StreamObserver)observer);
            latch.await();
            return this.toJSON((MessageOrBuilder)responseHeader[0], "changeResult");
        }
        catch (Exception e) {
            return this.toJSON((Throwable)e);
        }
    }
}

