/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.pd.RegistryService;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.common.PDRuntimeException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.discovery.DiscoveryServiceGrpc;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfo;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.grpc.discovery.RegisterInfo;
import org.apache.hugegraph.pd.license.LicenseVerifierService;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.raft.RaftStateListener;
import org.apache.hugegraph.pd.service.ServiceGrpc;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@GRpcService
public class DiscoveryService
extends DiscoveryServiceGrpc.DiscoveryServiceImplBase
implements ServiceGrpc {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryService.class);
    static final AtomicLong id = new AtomicLong();
    private static final String CORES = "cores";
    RegistryService register = null;
    LicenseVerifierService licenseVerifierService;
    @Autowired
    private PDConfig pdConfig;

    @PostConstruct
    public void init() throws PDException {
        log.info("PDService init\u2026\u2026\u2026\u2026 {}", (Object)this.pdConfig);
        RaftEngine.getInstance().init(this.pdConfig.getRaft());
        RaftEngine.getInstance().addStateListener((RaftStateListener)this);
        this.register = new RegistryService(this.pdConfig);
        this.licenseVerifierService = new LicenseVerifierService(this.pdConfig);
    }

    private Pdpb.ResponseHeader newErrorHeader(PDException e) {
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setTypeValue(e.getErrorCode()).setMessage(e.getMessage())).build();
        return header;
    }

    public void register(NodeInfo request, StreamObserver<RegisterInfo> observer) {
        RegisterInfo registerInfo;
        if (!this.isLeader()) {
            this.redirectToLeader(DiscoveryServiceGrpc.getRegisterMethod(), (Object)request, observer);
            return;
        }
        int outTimes = this.pdConfig.getDiscovery().getHeartbeatOutTimes();
        try {
            if (request.getAppName().equals("hg")) {
                Map labelsMap;
                String coreCount;
                Query queryRequest = Query.newBuilder().setAppName(request.getAppName()).setVersion(request.getVersion()).build();
                NodeInfos nodes = this.register.getNodes(queryRequest);
                String address = request.getAddress();
                int nodeCount = nodes.getInfoCount() + 1;
                for (NodeInfo node : nodes.getInfoList()) {
                    if (!node.getAddress().equals(address)) continue;
                    nodeCount = nodes.getInfoCount();
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)(coreCount = (String)(labelsMap = request.getLabelsMap()).get(CORES)))) {
                    throw new PDException(-1, "core count can not be null");
                }
                int core = Integer.parseInt(coreCount);
                this.licenseVerifierService.verify(core, nodeCount);
            }
            this.register.register(request, outTimes);
            String valueId = request.getId();
            registerInfo = RegisterInfo.newBuilder().setNodeInfo(NodeInfo.newBuilder().setId("0".equals(valueId) ? String.valueOf(id.incrementAndGet()) : valueId).build()).build();
        }
        catch (PDException e) {
            registerInfo = RegisterInfo.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.debug("registerStore exception: ", (Throwable)e);
        }
        catch (PDRuntimeException ex) {
            Pdpb.Error error = Pdpb.Error.newBuilder().setTypeValue(ex.getErrorCode()).setMessage(ex.getMessage()).build();
            Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(error).build();
            registerInfo = RegisterInfo.newBuilder().setHeader(header).build();
            log.debug("registerStore exception: ", (Throwable)ex);
        }
        catch (Exception e) {
            Pdpb.Error error = Pdpb.Error.newBuilder().setTypeValue(Pdpb.ErrorType.UNKNOWN.getNumber()).setMessage(e.getMessage()).build();
            Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(error).build();
            registerInfo = RegisterInfo.newBuilder().setHeader(header).build();
        }
        observer.onNext((Object)registerInfo);
        observer.onCompleted();
    }

    public void getNodes(Query request, StreamObserver<NodeInfos> responseObserver) {
        if (!this.isLeader()) {
            this.redirectToLeader(DiscoveryServiceGrpc.getGetNodesMethod(), (Object)request, responseObserver);
            return;
        }
        responseObserver.onNext((Object)this.register.getNodes(request));
        responseObserver.onCompleted();
    }

    public boolean isLeader() {
        return RaftEngine.getInstance().isLeader();
    }
}

