/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.stub.StreamObserver;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.GraphSpaces;
import org.apache.hugegraph.pd.grpc.Graphs;
import org.apache.hugegraph.pd.grpc.MetaServiceGrpc;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Partitions;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.ShardGroups;
import org.apache.hugegraph.pd.grpc.Stores;
import org.apache.hugegraph.pd.grpc.VoidResponse;
import org.apache.hugegraph.pd.grpc.common.NoArg;
import org.apache.hugegraph.pd.service.MetadataService;
import org.apache.hugegraph.pd.service.ServiceGrpc;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@GRpcService
public class MetaServiceGrpcImpl
extends MetaServiceGrpc.MetaServiceImplBase
implements ServiceGrpc {
    private static final Logger log = LoggerFactory.getLogger(MetaServiceGrpcImpl.class);
    @Autowired
    private MetadataService metadataService;

    public void getStores(NoArg request, StreamObserver<Stores> observer) {
        Stores response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getGetStoresMethod(), (Object)request, observer);
            return;
        }
        Stores.Builder builder = Stores.newBuilder();
        try {
            response = this.metadataService.getStores();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getGetStoresMethod(), (Object)request, observer);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getPartitions(NoArg request, StreamObserver<Partitions> observer) {
        Partitions response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getGetPartitionsMethod(), (Object)request, observer);
            return;
        }
        Partitions.Builder builder = Partitions.newBuilder();
        try {
            response = this.metadataService.getPartitions();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getGetPartitionsMethod(), (Object)request, observer);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getShardGroups(NoArg request, StreamObserver<ShardGroups> observer) {
        ShardGroups response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getGetShardGroupsMethod(), (Object)request, observer);
            return;
        }
        ShardGroups.Builder builder = ShardGroups.newBuilder();
        try {
            response = this.metadataService.getShardGroups();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getGetShardGroupsMethod(), (Object)request, observer);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getGraphSpaces(NoArg request, StreamObserver<GraphSpaces> observer) {
        GraphSpaces response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getGetGraphSpacesMethod(), (Object)request, observer);
            return;
        }
        GraphSpaces.Builder builder = GraphSpaces.newBuilder();
        try {
            response = this.metadataService.getGraphSpaces();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getGetGraphSpacesMethod(), (Object)request, observer);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getGraphs(NoArg request, StreamObserver<Graphs> observer) {
        Graphs response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getGetGraphsMethod(), (Object)request, observer);
            return;
        }
        Graphs.Builder builder = Graphs.newBuilder();
        try {
            response = this.metadataService.getGraphs();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getGetGraphsMethod(), (Object)request, observer);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updateStore(Metapb.Store request, StreamObserver<VoidResponse> observer) {
        VoidResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getUpdateStoreMethod(), (Object)request, observer);
            return;
        }
        VoidResponse.Builder builder = VoidResponse.newBuilder();
        try {
            this.metadataService.updateStore(request);
            response = builder.build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getUpdateStoreMethod(), (Object)request, observer);
                return;
            }
            Pdpb.ResponseHeader header = this.getResponseHeader(e);
            response = builder.setHeader(header).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updatePartition(Metapb.Partition request, StreamObserver<VoidResponse> observer) {
        VoidResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getUpdatePartitionMethod(), (Object)request, observer);
            return;
        }
        VoidResponse.Builder builder = VoidResponse.newBuilder();
        try {
            this.metadataService.updatePartition(request);
            response = builder.build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getUpdatePartitionMethod(), (Object)request, observer);
                return;
            }
            Pdpb.ResponseHeader header = this.getResponseHeader(e);
            response = builder.setHeader(header).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updateShardGroup(Metapb.ShardGroup request, StreamObserver<VoidResponse> observer) {
        VoidResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getUpdateShardGroupMethod(), (Object)request, observer);
            return;
        }
        VoidResponse.Builder builder = VoidResponse.newBuilder();
        try {
            this.metadataService.updateShardGroup(request);
            response = builder.build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getUpdateShardGroupMethod(), (Object)request, observer);
                return;
            }
            Pdpb.ResponseHeader header = this.getResponseHeader(e);
            response = builder.setHeader(header).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updateGraphSpace(Metapb.GraphSpace request, StreamObserver<VoidResponse> observer) {
        VoidResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getUpdateGraphSpaceMethod(), (Object)request, observer);
            return;
        }
        VoidResponse.Builder builder = VoidResponse.newBuilder();
        try {
            this.metadataService.updateGraphSpace(request);
            response = builder.build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getUpdateGraphSpaceMethod(), (Object)request, observer);
                return;
            }
            Pdpb.ResponseHeader header = this.getResponseHeader(e);
            response = builder.setHeader(header).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updateGraph(Metapb.Graph request, StreamObserver<VoidResponse> observer) {
        VoidResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(MetaServiceGrpc.getUpdateGraphMethod(), (Object)request, observer);
            return;
        }
        VoidResponse.Builder builder = VoidResponse.newBuilder();
        try {
            this.metadataService.updateGraph(request);
            response = builder.build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(MetaServiceGrpc.getUpdateGraphMethod(), (Object)request, observer);
                return;
            }
            Pdpb.ResponseHeader header = this.getResponseHeader(e);
            response = builder.setHeader(header).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }
}

