/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.session;

import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyCompilerGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.session.SessionOpProcessor;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.ThreadFactoryUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private final Bindings bindings;
    private final Settings settings;
    private final GraphManager graphManager;
    private final String session;
    private final ScheduledExecutorService scheduledExecutorService;
    private final long configuredSessionTimeout;
    private final long configuredPerGraphCloseTimeout;
    private final boolean globalFunctionCacheEnabled;
    private final Channel boundChannel;
    private AtomicBoolean killing = new AtomicBoolean(false);
    private AtomicReference<ScheduledFuture> kill = new AtomicReference();
    private final GremlinExecutor gremlinExecutor;
    private final ThreadFactory threadFactoryWorker = ThreadFactoryUtil.create("session-%d");
    private final ExecutorService executor = Executors.newSingleThreadExecutor(this.threadFactoryWorker);
    private final ConcurrentHashMap<String, Session> sessions;

    public Session(String session, Context context, ConcurrentHashMap<String, Session> sessions) {
        logger.debug("New session established for {}", (Object)session);
        this.session = session;
        this.bindings = new SimpleBindings();
        this.settings = context.getSettings();
        this.graphManager = context.getGraphManager();
        this.scheduledExecutorService = context.getScheduledExecutorService();
        this.sessions = sessions;
        Settings.ProcessorSettings processorSettings = this.settings.optionalProcessor(SessionOpProcessor.class).orElse(SessionOpProcessor.DEFAULT_SETTINGS);
        this.configuredSessionTimeout = Long.parseLong(processorSettings.config.getOrDefault("sessionTimeout", 28800000L).toString());
        this.configuredPerGraphCloseTimeout = Long.parseLong(processorSettings.config.getOrDefault("perGraphCloseTimeout", 10000L).toString());
        this.globalFunctionCacheEnabled = Boolean.parseBoolean(processorSettings.config.getOrDefault("globalFunctionCacheEnabled", true).toString());
        this.gremlinExecutor = this.initializeGremlinExecutor().create();
        this.settings.scriptEngines.keySet().forEach(this::registerMetrics);
        this.boundChannel = context.getChannelHandlerContext().channel();
        this.boundChannel.closeFuture().addListener(future -> this.manualKill(true));
    }

    public boolean isBoundTo(Channel channel) {
        return channel == this.boundChannel;
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public String getSessionId() {
        return this.session;
    }

    public boolean acceptingRequests() {
        return !this.killing.get();
    }

    public void touch() {
        this.kill.updateAndGet(future -> {
            if (null == future || !future.isDone()) {
                if (future != null) {
                    future.cancel(false);
                }
                return this.scheduledExecutorService.schedule(() -> {
                    logger.info("Session {} has been idle for more than {} milliseconds - preparing to close", (Object)this.session, (Object)this.configuredSessionTimeout);
                    this.kill(false);
                }, this.configuredSessionTimeout, TimeUnit.MILLISECONDS);
            }
            return future;
        });
    }

    public void manualKill(boolean force) {
        Optional.ofNullable(this.kill.get()).ifPresent(f -> f.cancel(true));
        this.kill(force);
    }

    public synchronized void kill(boolean force) {
        this.killing.set(true);
        if (!this.sessions.containsKey(this.session)) {
            return;
        }
        if (!force) {
            this.graphManager.getGraphNames().forEach(gName -> {
                Graph g = this.graphManager.getGraph((String)gName);
                if (g.features().graph().supportsTransactions()) {
                    try {
                        this.executor.submit(() -> {
                            if (g.tx().isOpen()) {
                                logger.debug("Rolling back open transactions on {} before killing session: {}", gName, (Object)this.session);
                                g.tx().rollback();
                            }
                        }).get(this.configuredPerGraphCloseTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("An error occurred while attempting rollback on %s when closing session: %s", gName, this.session), (Throwable)ex);
                    }
                }
            });
        } else {
            logger.debug("Skipped attempt to close open graph transactions on {} - close was forced", (Object)this.session);
        }
        this.executor.shutdownNow();
        this.sessions.remove(this.session);
        MetricManager.INSTANCE.getRegistry().removeMatching((s, metric) -> s.contains(this.session));
        logger.debug("Session {} closed", (Object)this.session);
    }

    private GremlinExecutor.Builder initializeGremlinExecutor() {
        GremlinExecutor.Builder gremlinExecutorBuilder = GremlinExecutor.build().evaluationTimeout(this.settings.getEvaluationTimeout()).afterTimeout(b -> {
            this.graphManager.rollbackAll();
            this.bindings.clear();
            this.bindings.putAll((Map<? extends String, ? extends Object>)b);
        }).afterSuccess(b -> {
            this.bindings.clear();
            this.bindings.putAll((Map<? extends String, ? extends Object>)b);
        }).globalBindings(this.graphManager.getAsBindings()).executorService(this.executor).scheduledExecutorService(this.scheduledExecutorService);
        this.settings.scriptEngines.forEach((k, v) -> {
            if (!v.plugins.isEmpty()) {
                if (v.plugins.containsKey(GroovyCompilerGremlinPlugin.class.getName())) {
                    v.plugins.get(GroovyCompilerGremlinPlugin.class.getName()).put("globalFunctionCacheEnabled", this.globalFunctionCacheEnabled);
                } else {
                    HashMap<String, Boolean> pluginConf = new HashMap<String, Boolean>();
                    pluginConf.put("globalFunctionCacheEnabled", this.globalFunctionCacheEnabled);
                    v.plugins.put(GroovyCompilerGremlinPlugin.class.getName(), pluginConf);
                }
                gremlinExecutorBuilder.addPlugins(k, v.plugins);
            }
        });
        return gremlinExecutorBuilder;
    }

    private void registerMetrics(String engineName) {
        GremlinScriptEngine engine = this.gremlinExecutor.getScriptEngineManager().getEngineByName(engineName);
        MetricManager.INSTANCE.registerGremlinScriptEngineMetrics(engine, engineName, "session", this.session, "class-cache");
    }
}

