/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.InflaterInputStream;
import org.gridkit.jvmtool.stacktrace.CounterArray;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;

class StackTraceReaderV1
implements StackTraceReader {
    private DataInputStream dis;
    private List<String> stringDic = new ArrayList<String>();
    private List<StackFrame> frameDic = new ArrayList<StackFrame>();
    private Map<StackFrame, StackTraceElement> frameCache = new HashMap<StackFrame, StackTraceElement>();
    private boolean loaded;
    private long threadId;
    private long timestamp;
    private StackFrameList trace;

    public StackTraceReaderV1(InputStream is) {
        this.dis = new DataInputStream(new BufferedInputStream(new InflaterInputStream(is), 65536));
        this.stringDic.add(null);
        this.frameDic.add(null);
        this.loaded = false;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public long getThreadId() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        return this.threadId;
    }

    @Override
    public long getTimestamp() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        return this.timestamp;
    }

    @Override
    public StackTraceElement[] getTrace() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        StackTraceElement[] strace = new StackTraceElement[this.trace.depth()];
        for (int i = 0; i != strace.length; ++i) {
            StackFrame frame = this.trace.frameAt(i);
            StackTraceElement e = this.frameCache.get(frame);
            if (e == null) {
                e = frame.toStackTraceElement();
                this.frameCache.put(frame, e);
            }
            strace[i] = e;
        }
        return strace;
    }

    @Override
    public StackFrameList getStackTrace() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        return this.trace;
    }

    @Override
    public String getThreadName() {
        return null;
    }

    @Override
    public Thread.State getThreadState() {
        return null;
    }

    @Override
    public CounterCollection getCounters() {
        return CounterArray.EMPTY;
    }

    @Override
    public boolean loadNext() throws IOException {
        block6: {
            int tag;
            this.loaded = false;
            while (true) {
                if ((tag = this.dis.read()) < 0) {
                    this.dis.close();
                    break block6;
                }
                if (tag == 1) {
                    String str = this.dis.readUTF();
                    this.stringDic.add(str);
                    continue;
                }
                if (tag != 2) break;
                StackFrame ste = this.readStackTraceElement();
                this.frameDic.add(ste);
            }
            if (tag == 3) {
                this.threadId = this.dis.readLong();
                this.timestamp = this.dis.readLong();
                int len = StackTraceCodec.readVarInt(this.dis);
                StackFrame[] frames = new StackFrame[len];
                for (int i = 0; i != len; ++i) {
                    int ref = StackTraceCodec.readVarInt(this.dis);
                    frames[i] = this.frameDic.get(ref);
                }
                this.trace = new StackFrameArray(frames);
                this.loaded = true;
            } else {
                throw new IOException("Data format error");
            }
        }
        return this.loaded;
    }

    private StackFrame readStackTraceElement() throws IOException {
        int npkg = StackTraceCodec.readVarInt(this.dis);
        int ncn = StackTraceCodec.readVarInt(this.dis);
        int nmtd = StackTraceCodec.readVarInt(this.dis);
        int nfile = StackTraceCodec.readVarInt(this.dis);
        int line = StackTraceCodec.readVarInt(this.dis) - 2;
        String cp = this.stringDic.get(npkg);
        String cn = this.stringDic.get(ncn);
        String mtd = this.stringDic.get(nmtd);
        String file = this.stringDic.get(nfile);
        StackFrame e = new StackFrame(cp, cn, mtd, file, line);
        return e;
    }
}

