/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hbase.thirdparty.com.google.common.base.Objects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class ClusterStatus
implements ClusterMetrics {
    private static final byte VERSION = 2;
    private final ClusterMetrics metrics;

    @Deprecated
    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, ServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, List<RegionState> rit, String[] masterCoprocessors, Boolean balancerOn, int masterInfoPort) {
        this(ClusterMetricsBuilder.newBuilder().setHBaseVersion(hbaseVersion).setDeadServerNames(new ArrayList<ServerName>(deadServers)).setLiveServerMetrics(servers.entrySet().stream().collect(Collectors.toMap(e -> (ServerName)e.getKey(), e -> (ServerLoad)e.getValue()))).setBackerMasterNames(new ArrayList<ServerName>(backupMasters)).setBalancerOn(balancerOn).setClusterId(clusterid).setMasterCoprocessorNames(Arrays.asList(masterCoprocessors)).setMasterName(master).setMasterInfoPort(masterInfoPort).setRegionsInTransition(rit).build());
    }

    @InterfaceAudience.Private
    public ClusterStatus(ClusterMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public List<ServerName> getDeadServerNames() {
        return this.metrics.getDeadServerNames();
    }

    @Override
    public Map<ServerName, ServerMetrics> getLiveServerMetrics() {
        return this.metrics.getLiveServerMetrics();
    }

    @Deprecated
    public int getServersSize() {
        return this.metrics.getLiveServerMetrics().size();
    }

    @Deprecated
    public int getDeadServers() {
        return this.getDeadServersSize();
    }

    @Deprecated
    public int getDeadServersSize() {
        return this.metrics.getDeadServerNames().size();
    }

    @Deprecated
    public int getRegionsCount() {
        return this.getRegionCount();
    }

    @Deprecated
    public int getRequestsCount() {
        return (int)this.getRequestCount();
    }

    @Override
    @Nullable
    public ServerName getMasterName() {
        return this.metrics.getMasterName();
    }

    @Override
    public List<ServerName> getBackupMasterNames() {
        return this.metrics.getBackupMasterNames();
    }

    @Override
    public List<RegionState> getRegionStatesInTransition() {
        return this.metrics.getRegionStatesInTransition();
    }

    @Override
    public String getHBaseVersion() {
        return this.metrics.getHBaseVersion();
    }

    private Map<ServerName, ServerLoad> getLiveServerLoads() {
        return this.metrics.getLiveServerMetrics().entrySet().stream().collect(Collectors.toMap(e -> (ServerName)e.getKey(), e -> new ServerLoad((ServerMetrics)e.getValue())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        ClusterStatus other = (ClusterStatus)o;
        return Objects.equal(this.getHBaseVersion(), other.getHBaseVersion()) && Objects.equal(this.getLiveServerLoads(), other.getLiveServerLoads()) && this.getDeadServerNames().containsAll(other.getDeadServerNames()) && Arrays.equals(this.getMasterCoprocessors(), other.getMasterCoprocessors()) && Objects.equal(this.getMaster(), other.getMaster()) && this.getBackupMasters().containsAll(other.getBackupMasters()) && Objects.equal(this.getClusterId(), other.getClusterId()) && this.getMasterInfoPort() == other.getMasterInfoPort();
    }

    public int hashCode() {
        return this.metrics.hashCode();
    }

    @Deprecated
    public byte getVersion() {
        return 2;
    }

    @Deprecated
    public Collection<ServerName> getServers() {
        return this.metrics.getLiveServerMetrics().keySet();
    }

    @Deprecated
    public ServerName getMaster() {
        return this.metrics.getMasterName();
    }

    @Deprecated
    public int getBackupMastersSize() {
        return this.metrics.getBackupMasterNames().size();
    }

    @Deprecated
    public List<ServerName> getBackupMasters() {
        return this.metrics.getBackupMasterNames();
    }

    @Deprecated
    public ServerLoad getLoad(ServerName sn) {
        ServerMetrics serverMetrics = this.metrics.getLiveServerMetrics().get(sn);
        return serverMetrics == null ? null : new ServerLoad(serverMetrics);
    }

    @Override
    public String getClusterId() {
        return this.metrics.getClusterId();
    }

    @Override
    public List<String> getMasterCoprocessorNames() {
        return this.metrics.getMasterCoprocessorNames();
    }

    @Deprecated
    public String[] getMasterCoprocessors() {
        List<String> rval = this.metrics.getMasterCoprocessorNames();
        return rval.toArray(new String[rval.size()]);
    }

    @Deprecated
    public long getLastMajorCompactionTsForTable(TableName table) {
        return this.metrics.getLastMajorCompactionTimestamp(table);
    }

    @Deprecated
    public long getLastMajorCompactionTsForRegion(byte[] region) {
        return this.metrics.getLastMajorCompactionTimestamp(region);
    }

    @Deprecated
    public boolean isBalancerOn() {
        return this.metrics.getBalancerOn() != null && this.metrics.getBalancerOn() != false;
    }

    @Override
    public Boolean getBalancerOn() {
        return this.metrics.getBalancerOn();
    }

    @Override
    public int getMasterInfoPort() {
        return this.metrics.getMasterInfoPort();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Master: " + this.metrics.getMasterName());
        int backupMastersSize = this.getBackupMastersSize();
        sb.append("\nNumber of backup masters: " + backupMastersSize);
        if (backupMastersSize > 0) {
            for (ServerName serverName : this.metrics.getBackupMasterNames()) {
                sb.append("\n  " + serverName);
            }
        }
        int serversSize = this.getServersSize();
        sb.append("\nNumber of live region servers: " + serversSize);
        if (serversSize > 0) {
            for (ServerName serverName : this.metrics.getLiveServerMetrics().keySet()) {
                sb.append("\n  " + serverName.getServerName());
            }
        }
        int n = this.metrics.getDeadServerNames().size();
        sb.append("\nNumber of dead region servers: " + n);
        if (n > 0) {
            for (ServerName serverName : this.metrics.getDeadServerNames()) {
                sb.append("\n  " + serverName);
            }
        }
        sb.append("\nAverage load: " + this.getAverageLoad());
        sb.append("\nNumber of requests: " + this.getRequestCount());
        sb.append("\nNumber of regions: " + this.getRegionsCount());
        int n2 = this.metrics.getRegionStatesInTransition().size();
        sb.append("\nNumber of regions in transition: " + n2);
        if (n2 > 0) {
            for (RegionState state : this.metrics.getRegionStatesInTransition()) {
                sb.append("\n  " + state.toDescriptiveString());
            }
        }
        return sb.toString();
    }
}

