/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc;

import java.util.Arrays;

public final class OHCacheStats {
    private final long hitCount;
    private final long missCount;
    private final long evictionCount;
    private final long expireCount;
    private final long[] segmentSizes;
    private final long capacity;
    private final long free;
    private final long size;
    private final long rehashCount;
    private final long putAddCount;
    private final long putReplaceCount;
    private final long putFailCount;
    private final long removeCount;
    private final long totalAllocated;
    private final long lruCompactions;

    public OHCacheStats(long hitCount, long missCount, long evictionCount, long expireCount, long[] segmentSizes, long size, long capacity, long free, long rehashCount, long putAddCount, long putReplaceCount, long putFailCount, long removeCount, long totalAllocated, long lruCompactions) {
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.evictionCount = evictionCount;
        this.expireCount = expireCount;
        this.segmentSizes = segmentSizes;
        this.size = size;
        this.capacity = capacity;
        this.free = free;
        this.rehashCount = rehashCount;
        this.putAddCount = putAddCount;
        this.putReplaceCount = putReplaceCount;
        this.putFailCount = putFailCount;
        this.removeCount = removeCount;
        this.totalAllocated = totalAllocated;
        this.lruCompactions = lruCompactions;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getFree() {
        return this.free;
    }

    public long getRehashCount() {
        return this.rehashCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }

    public long getExpireCount() {
        return this.expireCount;
    }

    public long[] getSegmentSizes() {
        return this.segmentSizes;
    }

    public long getSize() {
        return this.size;
    }

    public long getPutAddCount() {
        return this.putAddCount;
    }

    public long getPutReplaceCount() {
        return this.putReplaceCount;
    }

    public long getPutFailCount() {
        return this.putFailCount;
    }

    public long getRemoveCount() {
        return this.removeCount;
    }

    public double getAverageSegmentSize() {
        return OHCacheStats.avgOf(this.segmentSizes);
    }

    public long getMinSegmentSize() {
        return OHCacheStats.minOf(this.segmentSizes);
    }

    public long getMaxSegmentSize() {
        return OHCacheStats.maxOf(this.segmentSizes);
    }

    public long getTotalAllocated() {
        return this.totalAllocated;
    }

    public long getLruCompactions() {
        return this.lruCompactions;
    }

    public String toString() {
        return "OHCacheStats{hitCount=" + this.hitCount + ", missCount=" + this.missCount + ", evictionCount=" + this.evictionCount + ", expireCount=" + this.expireCount + ", size=" + this.size + ", capacity=" + this.capacity + ", free=" + this.free + ", rehashCount=" + this.rehashCount + ", put(add/replace/fail)=" + Long.toString(this.putAddCount) + '/' + this.putReplaceCount + '/' + this.putFailCount + ", removeCount=" + this.removeCount + ", segmentSizes(#/min/max/avg)=" + String.format("%d/%d/%d/%.2f", this.segmentSizes.length, this.getMinSegmentSize(), this.getMaxSegmentSize(), this.getAverageSegmentSize()) + ", totalAllocated=" + this.totalAllocated + ", lruCompactions=" + this.lruCompactions + '}';
    }

    private static long maxOf(long[] arr) {
        long r = 0L;
        for (long l : arr) {
            if (l <= r) continue;
            r = l;
        }
        return r;
    }

    private static long minOf(long[] arr) {
        long r = Long.MAX_VALUE;
        for (long l : arr) {
            if (l >= r) continue;
            r = l;
        }
        return r;
    }

    private static double avgOf(long[] arr) {
        double r = 0.0;
        for (long l : arr) {
            r += (double)l;
        }
        return r / (double)arr.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OHCacheStats that = (OHCacheStats)o;
        if (this.capacity != that.capacity) {
            return false;
        }
        if (this.evictionCount != that.evictionCount) {
            return false;
        }
        if (this.free != that.free) {
            return false;
        }
        if (this.hitCount != that.hitCount) {
            return false;
        }
        if (this.missCount != that.missCount) {
            return false;
        }
        if (this.putAddCount != that.putAddCount) {
            return false;
        }
        if (this.putFailCount != that.putFailCount) {
            return false;
        }
        if (this.putReplaceCount != that.putReplaceCount) {
            return false;
        }
        if (this.removeCount != that.removeCount) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        return Arrays.equals(this.segmentSizes, that.segmentSizes);
    }

    public int hashCode() {
        int result = (int)(this.hitCount ^ this.hitCount >>> 32);
        result = 31 * result + (int)(this.missCount ^ this.missCount >>> 32);
        result = 31 * result + (int)(this.evictionCount ^ this.evictionCount >>> 32);
        result = 31 * result + Arrays.hashCode(this.segmentSizes);
        result = 31 * result + (int)(this.capacity ^ this.capacity >>> 32);
        result = 31 * result + (int)(this.free ^ this.free >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.putAddCount ^ this.putAddCount >>> 32);
        result = 31 * result + (int)(this.putReplaceCount ^ this.putReplaceCount >>> 32);
        result = 31 * result + (int)(this.putFailCount ^ this.putFailCount >>> 32);
        result = 31 * result + (int)(this.removeCount ^ this.removeCount >>> 32);
        return result;
    }
}

