/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.traversers.Vertices;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.FusiformSimilarityTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/traversers/fusiformsimilarity")
@Singleton
@Tag(name="FusiformSimilarityAPI")
public class FusiformSimilarityAPI
extends API {
    private static final Logger LOG = Log.logger(FusiformSimilarityAPI.class);

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, FusiformSimilarityRequest request) {
        Iterator iterVertex;
        E.checkArgumentNotNull((Object)request, (String)"The fusiform similarity request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.sources, (String)"The sources of fusiform similarity request can't be null", (Object[])new Object[0]);
        if (request.direction == null) {
            request.direction = Directions.BOTH;
        }
        E.checkArgument((request.minNeighbors > 0 ? 1 : 0) != 0, (String)"The min neighbor count must be > 0, but got: %s", (Object[])new Object[]{request.minNeighbors});
        E.checkArgument((request.maxDegree > 0L || request.maxDegree == -1L ? 1 : 0) != 0, (String)"The max degree of request must be > 0 or == -1, but got: %s", (Object[])new Object[]{request.maxDegree});
        E.checkArgument((request.alpha > 0.0 && request.alpha <= 1.0 ? 1 : 0) != 0, (String)"The alpha of request must be in range (0, 1], but got '%s'", (Object[])new Object[]{request.alpha});
        E.checkArgument((request.minSimilars >= 1 ? 1 : 0) != 0, (String)"The min similar count of request must be >= 1, but got: %s", (Object[])new Object[]{request.minSimilars});
        E.checkArgument((request.top >= 0 ? 1 : 0) != 0, (String)"The top must be >= 0, but got: %s", (Object[])new Object[]{request.top});
        LOG.debug("Graph [{}] get fusiform similars from '{}' with direction '{}', edge label '{}', min neighbor count '{}', alpha '{}', min similar count '{}', group property '{}' and min group count '{}'", new Object[]{graph, request.sources, request.direction, request.label, request.minNeighbors, request.alpha, request.minSimilars, request.groupProperty, request.minGroups});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        HugeGraph g = FusiformSimilarityAPI.graph(manager, graphSpace, graph);
        Iterator<Vertex> sources = request.sources.vertices(g);
        E.checkArgument((sources != null && sources.hasNext() ? 1 : 0) != 0, (String)"The source vertices can't be empty", (Object[])new Object[0]);
        FusiformSimilarityTraverser traverser = new FusiformSimilarityTraverser(g);
        FusiformSimilarityTraverser.SimilarsMap result = traverser.fusiformSimilarity(sources, request.direction, request.label, request.minNeighbors, request.alpha, request.minSimilars, request.top, request.groupProperty, request.minGroups, request.maxDegree, request.capacity, (long)request.limit, request.withIntermediary);
        CloseableIterator.closeIterator(sources);
        measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        Set vertexIds = result.vertices();
        if (request.withVertex && !vertexIds.isEmpty()) {
            iterVertex = g.vertices(vertexIds.toArray());
            measure.addIterCount(vertexIds.size(), 0L);
        } else {
            iterVertex = vertexIds.iterator();
        }
        return manager.serializer((Graph)g, measure.measures()).writeSimilars(result, iterVertex);
    }

    private static class FusiformSimilarityRequest {
        @JsonProperty(value="sources")
        public Vertices sources;
        @JsonProperty(value="label")
        public String label;
        @JsonProperty(value="direction")
        public Directions direction;
        @JsonProperty(value="min_neighbors")
        public int minNeighbors;
        @JsonProperty(value="alpha")
        public double alpha;
        @JsonProperty(value="min_similars")
        public int minSimilars = 1;
        @JsonProperty(value="top")
        public int top;
        @JsonProperty(value="group_property")
        public String groupProperty;
        @JsonProperty(value="min_groups")
        public int minGroups;
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10");
        @JsonProperty(value="with_intermediary")
        public boolean withIntermediary = false;
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;

        private FusiformSimilarityRequest() {
        }

        public String toString() {
            return String.format("FusiformSimilarityRequest{sources=%s,label=%s,direction=%s,minNeighbors=%s,alpha=%s,minSimilars=%s,top=%s,groupProperty=%s,minGroups=%s,maxDegree=%s,capacity=%s,limit=%s,withIntermediary=%s,withVertex=%s}", this.sources, this.label, this.direction, this.minNeighbors, this.alpha, this.minSimilars, this.top, this.groupProperty, this.minGroups, this.maxDegree, this.capacity, this.limit, this.withIntermediary, this.withVertex);
        }
    }
}

