/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import org.apache.fury.Fury;
import org.apache.fury.io.ClassLoaderObjectInputStream;
import org.apache.fury.io.MemoryBufferObjectInput;
import org.apache.fury.io.MemoryBufferObjectOutput;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.memory.BigEndian;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.serializer.AbstractObjectSerializer;
import org.apache.fury.serializer.Serializer;

public class JavaSerializer
extends AbstractObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSerializer.class);
    private final MemoryBufferObjectInput objectInput;
    private final MemoryBufferObjectOutput objectOutput;
    private static final ClassValue<Method> writeObjectMethodCache = new ClassValue<Method>(){

        @Override
        protected Method computeValue(Class<?> type) {
            return JavaSerializer.getWriteObjectMethod(type, true);
        }
    };
    private static final ClassValue<Method> readObjectMethodCache = new ClassValue<Method>(){

        @Override
        protected Method computeValue(Class<?> type) {
            return JavaSerializer.getReadObjectMethod(type, true);
        }
    };
    private static final ClassValue<Method> readResolveCache = new ClassValue<Method>(){

        @Override
        protected Method computeValue(Class<?> type) {
            Method readResolve = JavaSerializer.getMethod(type, "readResolve", true);
            if (readResolve != null) {
                if (readResolve.getParameterTypes().length == 0 && readResolve.getReturnType() == Object.class) {
                    return readResolve;
                }
                LOG.warn("`readResolve` method doesn't match signature: `ANY-ACCESS-MODIFIER Object readResolve()`");
            }
            return null;
        }
    };
    private static final ClassValue<Method> writeReplaceCache = new ClassValue<Method>(){

        @Override
        protected Method computeValue(Class<?> type) {
            Method writeReplace = JavaSerializer.getMethod(type, "writeReplace", true);
            if (writeReplace != null) {
                if (writeReplace.getParameterTypes().length == 0 && writeReplace.getReturnType() == Object.class) {
                    return writeReplace;
                }
                LOG.warn("`writeReplace` method doesn't match signature: `ANY-ACCESS-MODIFIER Object writeReplace()");
            }
            return null;
        }
    };

    public JavaSerializer(Fury fury, Class<?> cls) {
        super(fury, cls);
        if (cls != SerializedLambda.class) {
            LOG.warn("{} use java built-in serialization, which is inefficient. Please replace it with a {} or implements {}", cls, Serializer.class.getName(), Externalizable.class.getName());
        }
        this.objectInput = new MemoryBufferObjectInput(fury, null);
        this.objectOutput = new MemoryBufferObjectOutput(fury, null);
    }

    @Override
    public void write(MemoryBuffer buffer, Object value) {
        try {
            this.objectOutput.setBuffer(buffer);
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.fury.getSerializationContext().get(this.objectOutput);
            if (objectOutputStream == null) {
                objectOutputStream = new ObjectOutputStream(this.objectOutput);
                this.fury.getSerializationContext().add(this.objectOutput, objectOutputStream);
            }
            objectOutputStream.writeObject(value);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            Platform.throwException(e);
        }
    }

    @Override
    public Object read(MemoryBuffer buffer) {
        try {
            this.objectInput.setBuffer(buffer);
            ObjectInputStream objectInputStream = (ObjectInputStream)this.fury.getSerializationContext().get(this.objectInput);
            if (objectInputStream == null) {
                objectInputStream = new ClassLoaderObjectInputStream(this.fury.getClassLoader(), this.objectInput);
                this.fury.getSerializationContext().add(this.objectInput, objectInputStream);
            }
            return objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Platform.throwException(e);
            throw new IllegalStateException("unreachable code");
        }
    }

    public static Method getWriteObjectMethod(Class<?> clz) {
        return writeObjectMethodCache.get(clz);
    }

    public static Method getWriteObjectMethod(Class<?> clz, boolean searchParent) {
        Method writeObject = JavaSerializer.getMethod(clz, "writeObject", searchParent);
        if (writeObject != null && JavaSerializer.isWriteObjectMethod(writeObject)) {
            return writeObject;
        }
        return null;
    }

    public static boolean isWriteObjectMethod(Method method) {
        return method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == ObjectOutputStream.class && method.getReturnType() == Void.TYPE && Modifier.isPrivate(method.getModifiers());
    }

    public static Method getReadObjectMethod(Class<?> clz) {
        return readObjectMethodCache.get(clz);
    }

    public static Method getReadObjectMethod(Class<?> clz, boolean searchParent) {
        Method readObject = JavaSerializer.getMethod(clz, "readObject", searchParent);
        if (readObject != null && JavaSerializer.isReadObjectMethod(readObject)) {
            return readObject;
        }
        return null;
    }

    public static boolean isReadObjectMethod(Method method) {
        return method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == ObjectInputStream.class && method.getReturnType() == Void.TYPE && Modifier.isPrivate(method.getModifiers());
    }

    public static Method getReadObjectNoData(Class<?> clz, boolean searchParent) {
        Method method = JavaSerializer.getMethod(clz, "readObjectNoData", searchParent);
        if (method != null && method.getParameterTypes().length == 0 && method.getReturnType() == Void.TYPE && Modifier.isPrivate(method.getModifiers())) {
            return method;
        }
        return null;
    }

    public static Method getReadResolveMethod(Class<?> clz) {
        return readResolveCache.get(clz);
    }

    public static Method getWriteReplaceMethod(Class<?> clz) {
        return writeReplaceCache.get(clz);
    }

    private static Method getMethod(Class<?> clz, String methodName, boolean searchParent) {
        Class<?> cls = clz;
        do {
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
        } while ((cls = cls.getSuperclass()) != null && searchParent);
        return null;
    }

    public static boolean serializedByJDK(byte[] data) {
        return JavaSerializer.serializedByJDK(data, 0);
    }

    public static boolean serializedByJDK(byte[] data, int offset) {
        short magicNumber = BigEndian.getShortB(data, offset);
        return magicNumber == -21267;
    }

    public static boolean serializedByJDK(ByteBuffer buffer, int offset) {
        byte b0;
        byte b1 = buffer.get(offset + 1);
        short magicNumber = (short)((b1 & 0xFF) + ((b0 = buffer.get(offset)) << 8));
        return magicNumber == -21267;
    }
}

