/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import com.google.common.collect.ImmutableMap;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.id.IdUtil;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.TableDefine;
import org.apache.hugegraph.backend.store.mysql.MysqlBackendEntry;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlTable;
import org.apache.hugegraph.backend.store.mysql.ResultSetWrapper;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;

public class MysqlTables {
    public static final String BOOLEAN = "BOOLEAN";
    public static final String TINYINT = "TINYINT";
    public static final String INT = "INT";
    public static final String BIGINT = "BIGINT";
    public static final String NUMERIC = "DOUBLE";
    public static final String SMALL_TEXT = "SMALL_TEXT";
    public static final String MID_TEXT = "MID_TEXT";
    public static final String LARGE_TEXT = "LARGE_TEXT";
    public static final String HUGE_TEXT = "HUGE_TEXT";
    private static final String DATATYPE_PK = "INT";
    private static final String DATATYPE_SL = "INT";
    private static final String DATATYPE_IL = "INT";
    private static final String SMALL_JSON = "MID_TEXT";
    private static final String LARGE_JSON = "LARGE_TEXT";
    private static final Map<String, String> TYPES_MAPPING = ImmutableMap.of((Object)"SMALL_TEXT", (Object)"VARCHAR(255)", (Object)"MID_TEXT", (Object)"VARCHAR(1024)", (Object)"LARGE_TEXT", (Object)"TEXT", (Object)"HUGE_TEXT", (Object)"MEDIUMTEXT");

    public static class ShardIndex
    extends Index {
        public static final String TABLE = HugeType.SHARD_INDEX.string();

        public ShardIndex(String store) {
            this(store, TYPES_MAPPING);
        }

        public ShardIndex(String store, Map<String, String> typesMapping) {
            super(ShardIndex.joinTableName((String)store, (String)TABLE));
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT"});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }

        @Override
        public final String entryId(MysqlBackendEntry entry) {
            Double fieldValue = (Double)entry.column(HugeKeys.FIELD_VALUES);
            Integer labelId = (Integer)entry.column(HugeKeys.INDEX_LABEL_ID);
            return SplicingIdGenerator.concat((String[])new String[]{labelId.toString(), fieldValue.toString()});
        }
    }

    public static class RangeDoubleIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_DOUBLE_INDEX.string();

        public RangeDoubleIndex(String store) {
            this(store, TABLE, TYPES_MAPPING);
        }

        public RangeDoubleIndex(String store, String table, Map<String, String> typesMapping) {
            super(store, table);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT"});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{MysqlTables.NUMERIC});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }
    }

    public static class RangeLongIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_LONG_INDEX.string();

        public RangeLongIndex(String store) {
            this(store, TABLE, TYPES_MAPPING);
        }

        public RangeLongIndex(String store, String table, Map<String, String> typesMapping) {
            super(store, table);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT"});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{MysqlTables.BIGINT});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }
    }

    public static class RangeFloatIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_FLOAT_INDEX.string();

        public RangeFloatIndex(String store) {
            this(store, TABLE, TYPES_MAPPING);
        }

        public RangeFloatIndex(String store, String table, Map<String, String> typesMapping) {
            super(store, table);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT"});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{MysqlTables.NUMERIC});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }
    }

    public static class RangeIntIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_INT_INDEX.string();

        public RangeIntIndex(String store) {
            this(store, TABLE, TYPES_MAPPING);
        }

        public RangeIntIndex(String store, String table, Map<String, String> typesMapping) {
            super(store, table);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT"});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{"INT"});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }
    }

    public static class RangeIndex
    extends Index {
        public RangeIndex(String store, String table) {
            this(store, table, TYPES_MAPPING);
        }

        public RangeIndex(String store, String table, Map<String, String> typesMapping) {
            super(RangeIndex.joinTableName((String)store, (String)table));
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT"});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{MysqlTables.NUMERIC});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }

        @Override
        public final String entryId(MysqlBackendEntry entry) {
            Double fieldValue = (Double)entry.column(HugeKeys.FIELD_VALUES);
            Integer labelId = (Integer)entry.column(HugeKeys.INDEX_LABEL_ID);
            return SplicingIdGenerator.concat((String[])new String[]{labelId.toString(), fieldValue.toString()});
        }
    }

    public static class UniqueIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.UNIQUE_INDEX.string();

        public UniqueIndex(String store) {
            super(store, TABLE, TYPES_MAPPING);
        }
    }

    public static class SearchIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.SEARCH_INDEX.string();

        public SearchIndex(String store) {
            super(store, TABLE, TYPES_MAPPING);
        }
    }

    public static class SecondaryIndex
    extends Index {
        public static final String TABLE = HugeType.SECONDARY_INDEX.string();

        public SecondaryIndex(String store) {
            this(store, TABLE, TYPES_MAPPING);
        }

        public SecondaryIndex(String store, String table, Map<String, String> typesMapping) {
            super(SecondaryIndex.joinTableName((String)store, (String)table));
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT"});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.FIELD_VALUES, HugeKeys.INDEX_LABEL_ID, HugeKeys.ELEMENT_IDS});
        }

        @Override
        public final String entryId(MysqlBackendEntry entry) {
            String fieldValues = (String)entry.column(HugeKeys.FIELD_VALUES);
            Integer labelId = (Integer)entry.column(HugeKeys.INDEX_LABEL_ID);
            return SplicingIdGenerator.concat((String[])new String[]{fieldValues, labelId.toString()});
        }
    }

    public static abstract class Index
    extends MysqlTableTemplate {
        public Index(String table) {
            super(table);
        }

        protected abstract String entryId(MysqlBackendEntry var1);
    }

    public static class Edge
    extends MysqlTableTemplate {
        public static final String TABLE_SUFFIX = HugeType.EDGE.string();
        private final Directions direction;
        private final String delByLabelTemplate;

        public Edge(String store, Directions direction) {
            this(store, direction, TYPES_MAPPING);
        }

        public Edge(String store, Directions direction, Map<String, String> typesMapping) {
            super(Edge.joinTableName((String)store, (String)Edge.table(direction)));
            this.direction = direction;
            this.delByLabelTemplate = String.format("DELETE FROM %s WHERE %s = ?;", this.table(), Edge.formatKey(HugeKeys.LABEL));
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.OWNER_VERTEX, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.DIRECTION, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.LABEL, new String[]{"INT"});
            this.define.column(HugeKeys.SUB_LABEL, new String[]{"INT"});
            this.define.column(HugeKeys.SORT_VALUES, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.OTHER_VERTEX, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.PROPERTIES, new String[]{"LARGE_TEXT"});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.OWNER_VERTEX, HugeKeys.DIRECTION, HugeKeys.LABEL, HugeKeys.SUB_LABEL, HugeKeys.SORT_VALUES, HugeKeys.OTHER_VERTEX});
        }

        @Override
        public List<Object> idColumnValue(Id id) {
            EdgeId edgeId;
            if (id instanceof EdgeId) {
                edgeId = (EdgeId)id;
            } else {
                String[] idParts = EdgeId.split((Id)id);
                if (idParts.length == 1) {
                    return Arrays.asList(idParts);
                }
                id = IdUtil.readString((String)id.asString());
                edgeId = EdgeId.parse((String)id.asString());
            }
            E.checkState((edgeId.direction() == this.direction ? 1 : 0) != 0, (String)"Can't query %s edges from %s edges table", (Object[])new Object[]{edgeId.direction(), this.direction});
            ArrayList<Object> list = new ArrayList<Object>(5);
            list.add(IdUtil.writeStoredString((Id)edgeId.ownerVertexId()));
            list.add(edgeId.directionCode());
            list.add(edgeId.edgeLabelId().asLong());
            list.add(edgeId.subLabelId().asLong());
            list.add(edgeId.sortValues());
            list.add(IdUtil.writeStoredString((Id)edgeId.otherVertexId()));
            return list;
        }

        @Override
        public void delete(MysqlSessions.Session session, TableBackendEntry.Row entry) {
            List<Object> idParts = this.idColumnValue(entry.id());
            if (idParts.size() > 1 || !entry.columns().isEmpty()) {
                super.delete(session, entry);
                return;
            }
            this.deleteEdgesByLabel(session, entry.id());
        }

        private void deleteEdgesByLabel(MysqlSessions.Session session, Id label) {
            PreparedStatement deleteStmt;
            try {
                deleteStmt = session.prepareStatement(this.delByLabelTemplate);
                deleteStmt.setObject(1, label.asLong());
            }
            catch (SQLException e) {
                throw new BackendException("Failed to prepare statement '%s'", new Object[]{this.delByLabelTemplate});
            }
            session.add(deleteStmt);
        }

        @Override
        public BackendEntry mergeEntries(BackendEntry e1, BackendEntry e2) {
            MysqlBackendEntry current = (MysqlBackendEntry)e1;
            MysqlBackendEntry next = (MysqlBackendEntry)e2;
            E.checkState((current == null || current.type().isVertex() ? 1 : 0) != 0, (String)"The current entry must be null or VERTEX", (Object[])new Object[0]);
            E.checkState((next != null && next.type().isEdge() ? 1 : 0) != 0, (String)"The next entry must be EDGE", (Object[])new Object[0]);
            long maxSize = 500L;
            if (current != null && (long)current.subRows().size() < maxSize) {
                Id nextVertexId = IdGenerator.of((String)((String)next.column(HugeKeys.OWNER_VERTEX)));
                if (current.id().equals(nextVertexId)) {
                    current.subRow(next.row());
                    return current;
                }
            }
            return this.wrapByVertex(next);
        }

        private MysqlBackendEntry wrapByVertex(MysqlBackendEntry edge) {
            assert (edge.type().isEdge());
            String ownerVertex = (String)edge.column(HugeKeys.OWNER_VERTEX);
            E.checkState((ownerVertex != null ? 1 : 0) != 0, (String)"Invalid backend entry", (Object[])new Object[0]);
            Id vertexId = IdGenerator.of((String)ownerVertex);
            MysqlBackendEntry vertex = new MysqlBackendEntry(HugeType.VERTEX, vertexId);
            vertex.column(HugeKeys.ID, ownerVertex);
            vertex.column(HugeKeys.PROPERTIES, "");
            vertex.subRow(edge.row());
            return vertex;
        }

        public static String table(Directions direction) {
            assert (direction == Directions.OUT || direction == Directions.IN);
            return direction.type().string() + TABLE_SUFFIX;
        }

        public static MysqlTable out(String store) {
            return new Edge(store, Directions.OUT);
        }

        public static MysqlTable in(String store) {
            return new Edge(store, Directions.IN);
        }
    }

    public static class Vertex
    extends MysqlTableTemplate {
        public static final String TABLE = HugeType.VERTEX.string();

        public Vertex(String store) {
            this(store, TYPES_MAPPING);
        }

        public Vertex(String store, Map<String, String> typesMapping) {
            super(Vertex.joinTableName((String)store, (String)TABLE));
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.ID, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.LABEL, new String[]{"INT"});
            this.define.column(HugeKeys.PROPERTIES, new String[]{MysqlTables.HUGE_TEXT});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{MysqlTables.BIGINT});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class IndexLabel
    extends MysqlTableTemplate {
        public static final String TABLE = HugeType.INDEX_LABEL.string();

        public IndexLabel() {
            this(TYPES_MAPPING);
        }

        public IndexLabel(Map<String, String> typesMapping) {
            super(TABLE);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.ID, new String[]{"INT"});
            this.define.column(HugeKeys.NAME, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.BASE_TYPE, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.BASE_VALUE, new String[]{"INT"});
            this.define.column(HugeKeys.INDEX_TYPE, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.FIELDS, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.USER_DATA, new String[]{"LARGE_TEXT"});
            this.define.column(HugeKeys.STATUS, new String[]{MysqlTables.TINYINT});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class PropertyKey
    extends MysqlTableTemplate {
        public static final String TABLE = HugeType.PROPERTY_KEY.string();

        public PropertyKey() {
            this(TYPES_MAPPING);
        }

        public PropertyKey(Map<String, String> typesMapping) {
            super(TABLE);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.ID, new String[]{"INT"});
            this.define.column(HugeKeys.NAME, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.DATA_TYPE, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.CARDINALITY, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.AGGREGATE_TYPE, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.WRITE_TYPE, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.PROPERTIES, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.USER_DATA, new String[]{"LARGE_TEXT"});
            this.define.column(HugeKeys.STATUS, new String[]{MysqlTables.TINYINT});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class EdgeLabel
    extends MysqlTableTemplate {
        public static final String TABLE = HugeType.EDGE_LABEL.string();

        public EdgeLabel() {
            this(TYPES_MAPPING);
        }

        public EdgeLabel(Map<String, String> typesMapping) {
            super(TABLE);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.ID, new String[]{"INT"});
            this.define.column(HugeKeys.NAME, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.FREQUENCY, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.SOURCE_LABEL, new String[]{"INT"});
            this.define.column(HugeKeys.TARGET_LABEL, new String[]{"INT"});
            this.define.column(HugeKeys.SORT_KEYS, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.PROPERTIES, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.NULLABLE_KEYS, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.INDEX_LABELS, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.ENABLE_LABEL_INDEX, new String[]{MysqlTables.BOOLEAN});
            this.define.column(HugeKeys.USER_DATA, new String[]{"LARGE_TEXT"});
            this.define.column(HugeKeys.STATUS, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.TTL, new String[]{"INT"});
            this.define.column(HugeKeys.TTL_START_TIME, new String[]{"INT"});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class VertexLabel
    extends MysqlTableTemplate {
        public static final String TABLE = HugeType.VERTEX_LABEL.string();

        public VertexLabel() {
            this(TYPES_MAPPING);
        }

        public VertexLabel(Map<String, String> typesMapping) {
            super(TABLE);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.ID, new String[]{"INT"});
            this.define.column(HugeKeys.NAME, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.ID_STRATEGY, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.PRIMARY_KEYS, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.PROPERTIES, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.NULLABLE_KEYS, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.INDEX_LABELS, new String[]{"MID_TEXT"});
            this.define.column(HugeKeys.ENABLE_LABEL_INDEX, new String[]{MysqlTables.BOOLEAN});
            this.define.column(HugeKeys.USER_DATA, new String[]{"LARGE_TEXT"});
            this.define.column(HugeKeys.STATUS, new String[]{MysqlTables.TINYINT});
            this.define.column(HugeKeys.TTL, new String[]{"INT"});
            this.define.column(HugeKeys.TTL_START_TIME, new String[]{"INT"});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class Counters
    extends MysqlTableTemplate {
        public static final String TABLE = HugeType.COUNTER.string();

        public Counters() {
            this(TYPES_MAPPING);
        }

        public Counters(Map<String, String> typesMapping) {
            super(TABLE);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.SCHEMA_TYPE, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.ID, new String[]{"INT"});
            this.define.keys(new HugeKeys[]{HugeKeys.SCHEMA_TYPE});
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long getCounter(MysqlSessions.Session session, HugeType type) {
            String schemaCol = Counters.formatKey(HugeKeys.SCHEMA_TYPE);
            String idCol = Counters.formatKey(HugeKeys.ID);
            String select = String.format("SELECT ID FROM %s WHERE %s = '%s';", this.table(), schemaCol, type.name());
            try (ResultSetWrapper results = session.select(select);){
                ResultSet rs = results.resultSet();
                if (rs.next()) {
                    long l = rs.getLong(idCol);
                    return l;
                }
                long l = 0L;
                return l;
            }
            catch (SQLException e) {
                throw new BackendException("Failed to get id from counters with type '%s'", (Throwable)e, new Object[]{type});
            }
        }

        public void increaseCounter(MysqlSessions.Session session, HugeType type, long increment) {
            String update = String.format("INSERT INTO %s VALUES ('%s', %s) ON DUPLICATE KEY UPDATE ID = ID + %s;", this.table(), type.name(), increment, increment);
            try {
                session.execute(update);
            }
            catch (SQLException e) {
                throw new BackendException("Failed to update counters with '%s'", (Throwable)e, new Object[]{update});
            }
        }
    }

    public static class Meta
    extends MysqlTableTemplate {
        public static final String TABLE = HugeType.META.string();

        public Meta() {
            this(TYPES_MAPPING);
        }

        public Meta(Map<String, String> typesMapping) {
            super(TABLE);
            this.define = new TableDefine(typesMapping);
            this.define.column(HugeKeys.NAME, new String[]{MysqlTables.SMALL_TEXT});
            this.define.column(HugeKeys.VALUE, new String[]{"MID_TEXT"});
            this.define.keys(new HugeKeys[]{HugeKeys.NAME});
        }

        public void writeVersion(MysqlSessions.Session session, String driverVersion) {
            String versionColumn = Meta.formatKey(HugeKeys.VERSION);
            String insert = String.format("INSERT IGNORE INTO %s VALUES ('%s', '%s')", this.table(), versionColumn, driverVersion);
            try {
                session.execute(insert);
            }
            catch (SQLException e) {
                throw new BackendException("Failed to insert driver version with '%s'", (Throwable)e, new Object[]{insert});
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String readVersion(MysqlSessions.Session session) {
            String select = String.format("SELECT %s FROM %s WHERE %s = '%s'", Meta.formatKey(HugeKeys.VALUE), this.table(), Meta.formatKey(HugeKeys.NAME), Meta.formatKey(HugeKeys.VERSION));
            try (ResultSetWrapper results = session.select(select);){
                ResultSet rs = results.resultSet();
                if (!rs.next()) {
                    String string = null;
                    return string;
                }
                String string = rs.getString(Meta.formatKey(HugeKeys.VALUE));
                return string;
            }
            catch (SQLException e) {
                throw new BackendException("Failed to get stored version with '%s'", (Throwable)e, new Object[]{select});
            }
        }
    }

    public static class MysqlTableTemplate
    extends MysqlTable {
        protected TableDefine define;

        public MysqlTableTemplate(String table) {
            super(table);
        }

        @Override
        public TableDefine tableDefine() {
            return this.define;
        }
    }
}

