/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query;

import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.query.QueryRequest;
import org.apache.hugegraph.store.grpc.query.QueryResponse;
import org.apache.hugegraph.store.grpc.query.QueryServiceGrpc;
import org.apache.hugegraph.store.node.grpc.query.AggregativeQueryObserver;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.options.HgStoreEngineOptions;
import org.apache.hugegraph.store.query.KvSerializer;
import org.apache.hugegraph.store.util.ExecutorUtil;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@GRpcService
public class AggregativeQueryService
extends QueryServiceGrpc.QueryServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(AggregativeQueryService.class);
    private final int batchSize;
    private final Long timeout;
    private final ThreadPoolExecutor threadPool;

    public AggregativeQueryService() {
        HgStoreEngineOptions.QueryPushDownOption queryPushDownOption = HgStoreEngine.getInstance().getOption().getQueryPushDownOption();
        this.timeout = queryPushDownOption.getFetchTimeout();
        this.batchSize = queryPushDownOption.getFetchBatchSize();
        this.threadPool = ExecutorUtil.createExecutor((String)"hg-scan-v2", (int)Runtime.getRuntime().availableProcessors(), (int)queryPushDownOption.getThreadPoolSize(), (int)10000, (boolean)true);
    }

    public static QueryResponse errorResponse(QueryResponse.Builder builder, String queryId, Throwable t) {
        return builder.setQueryId(queryId).setIsOk(false).setIsFinished(false).setMessage(t.getMessage() == null ? "" : t.getMessage()).build();
    }

    public StreamObserver<QueryRequest> query(StreamObserver<QueryResponse> observer) {
        return new AggregativeQueryObserver(observer, (ExecutorService)this.threadPool, this.timeout.longValue(), this.batchSize);
    }

    public void query0(QueryRequest request, StreamObserver<QueryResponse> observer) {
        ScanIterator itr = QueryUtil.getIterator((QueryRequest)request);
        QueryResponse.Builder builder = QueryResponse.newBuilder();
        Kv.Builder kvBuilder = Kv.newBuilder();
        try {
            while (itr.hasNext()) {
                RocksDBSession.BackendColumn column = (RocksDBSession.BackendColumn)itr.next();
                if (column == null) continue;
                builder.addData(kvBuilder.setKey(ByteString.copyFrom((byte[])column.name)).setValue(column.value == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])column.value)).build());
            }
            builder.setQueryId(request.getQueryId());
            builder.setIsOk(true);
            builder.setIsFinished(true);
            observer.onNext((Object)builder.build());
        }
        catch (Exception e) {
            observer.onNext((Object)AggregativeQueryService.errorResponse((QueryResponse.Builder)builder, (String)request.getQueryId(), (Throwable)e));
        }
        observer.onCompleted();
    }

    public void count(QueryRequest request, StreamObserver<QueryResponse> observer) {
        log.debug("query id : {}, simple count of table: {}", (Object)request.getQueryId(), (Object)request.getTable());
        QueryResponse.Builder builder = QueryResponse.newBuilder();
        Kv.Builder kvBuilder = Kv.newBuilder();
        try {
            BusinessHandler handler = new QueryUtil().getHandler();
            long start = System.currentTimeMillis();
            long count = handler.count(request.getGraph(), request.getTable());
            log.debug("query id: {}, count of cost: {} ms", (Object)request.getQueryId(), (Object)(System.currentTimeMillis() - start));
            ArrayList<AtomicLong> array = new ArrayList<AtomicLong>();
            for (int i = 0; i < request.getFunctionsList().size(); ++i) {
                array.add(new AtomicLong(count));
            }
            kvBuilder.setKey(ByteString.copyFrom((byte[])KvSerializer.toBytes(List.of())));
            kvBuilder.setValue(ByteString.copyFrom((byte[])KvSerializer.toBytes(array)));
            builder.addData(kvBuilder.build());
            builder.setQueryId(request.getQueryId());
            builder.setIsOk(true);
            builder.setIsFinished(true);
            observer.onNext((Object)builder.build());
        }
        catch (Exception e) {
            observer.onNext((Object)AggregativeQueryService.errorResponse((QueryResponse.Builder)builder, (String)request.getQueryId(), (Throwable)e));
        }
        observer.onCompleted();
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }
}

