/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.scan;

import com.google.protobuf.Descriptors;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.business.GraphStoreIterator;
import org.apache.hugegraph.store.grpc.Graphpb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanResponseObserver<T>
implements StreamObserver<Graphpb.ScanPartitionRequest> {
    private static final Logger log = LoggerFactory.getLogger(ScanResponseObserver.class);
    private static final int BATCH_SIZE = 100000;
    private static final int MAX_PAGE = 8;
    private static final Graphpb.Error ok = Graphpb.Error.newBuilder().setType(Graphpb.ErrorType.OK).build();
    private static final Graphpb.ResponseHeader okHeader = Graphpb.ResponseHeader.newBuilder().setError(ok).build();
    private final BusinessHandler handler;
    private final AtomicInteger nextSeqNo = new AtomicInteger(0);
    private final AtomicInteger cltSeqNo = new AtomicInteger(0);
    private final ThreadPoolExecutor executor;
    private final AtomicBoolean readOver = new AtomicBoolean(false);
    private final LinkedBlockingQueue<Graphpb.ScanResponse> packages = new LinkedBlockingQueue(16);
    private final Descriptors.FieldDescriptor vertexField = Graphpb.ScanResponse.getDescriptor().findFieldByNumber(3);
    private final Descriptors.FieldDescriptor edgeField = Graphpb.ScanResponse.getDescriptor().findFieldByNumber(4);
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock sendLock = new ReentrantLock();
    private StreamObserver<Graphpb.ScanResponse> sender;
    private Graphpb.ScanPartitionRequest scanReq;
    private GraphStoreIterator iter;
    private volatile long leftCount;
    private volatile Future<?> sendTask;
    private volatile Future<?> readTask;
    Runnable rr = new /* Unavailable Anonymous Inner Class!! */;
    Runnable sr = () -> {
        while (this.sendCondition()) {
            try {
                Graphpb.ScanResponse response;
                if (this.readOver.get()) {
                    response = (Graphpb.ScanResponse)this.packages.poll();
                    if (response == null) {
                        this.sender.onCompleted();
                        continue;
                    }
                    this.sender.onNext((Object)response);
                    this.nextSeqNo.incrementAndGet();
                    continue;
                }
                response = (Graphpb.ScanResponse)this.packages.poll(10L, TimeUnit.MILLISECONDS);
                if (response == null) break;
                this.sender.onNext((Object)response);
                this.nextSeqNo.incrementAndGet();
                this.startRead();
            }
            catch (InterruptedException e) {
                break;
            }
        }
    };

    public ScanResponseObserver(StreamObserver<Graphpb.ScanResponse> sender, BusinessHandler handler, ThreadPoolExecutor executor) {
        this.sender = sender;
        this.handler = handler;
        this.executor = executor;
    }

    private boolean readCondition() {
        return this.packages.remainingCapacity() != 0 && !this.readOver.get();
    }

    private boolean readTaskCondition() {
        return this.readCondition() && (this.readTask == null || this.readTask.isDone());
    }

    private boolean sendCondition() {
        return this.nextSeqNo.get() - this.cltSeqNo.get() < 8;
    }

    private boolean sendTaskCondition() {
        return this.sendCondition() && (this.sendTask == null || this.sendTask.isDone());
    }

    private void offer(Iterable<T> data, boolean isVertex) {
        Graphpb.ScanResponse.Builder builder = Graphpb.ScanResponse.newBuilder();
        builder.setHeader(okHeader).setSeqNo(this.nextSeqNo.get());
        builder = isVertex ? builder.setField(this.vertexField, data) : builder.setField(this.edgeField, data);
        Graphpb.ScanResponse response = builder.build();
        this.packages.offer(response);
        this.startSend();
    }

    private void startRead() {
        if (this.readTaskCondition() && this.readLock.tryLock()) {
            if (this.readTaskCondition()) {
                this.readTask = this.executor.submit(this.rr);
            }
            this.readLock.unlock();
        }
    }

    private void startSend() {
        if (this.sendTaskCondition() && this.sendLock.tryLock()) {
            if (this.sendTaskCondition()) {
                this.sendTask = this.executor.submit(this.sr);
            }
            this.sendLock.unlock();
        }
    }

    public void onNext(Graphpb.ScanPartitionRequest scanReq) {
        if (scanReq.hasScanRequest() && !scanReq.hasReplyRequest()) {
            this.scanReq = scanReq;
            Graphpb.ScanPartitionRequest.Request request = scanReq.getScanRequest();
            long rl = request.getLimit();
            this.leftCount = rl > 0L ? rl : Long.MAX_VALUE;
            this.iter = this.handler.scan(scanReq);
            if (!this.iter.hasNext()) {
                this.close();
                this.sender.onCompleted();
            } else {
                this.readTask = this.executor.submit(this.rr);
            }
        } else {
            this.cltSeqNo.getAndIncrement();
            this.startSend();
        }
    }

    public void onError(Throwable t) {
        this.close();
        log.warn("receive client error:", t);
    }

    public void onCompleted() {
        this.close();
    }

    private void close() {
        try {
            this.nextSeqNo.set(0);
            if (this.sendTask != null) {
                this.sendTask.cancel(true);
            }
            if (this.readTask != null) {
                this.readTask.cancel(true);
            }
            this.readOver.set(true);
            this.iter.close();
        }
        catch (Exception e) {
            log.warn("on Complete with error:", (Throwable)e);
        }
    }
}

